/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.network.MessageTileEntity;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PacketItemFilter
extends MessageTileEntity<TileTransceiver>
implements IMessageHandler<PacketItemFilter, IMessage> {
    private boolean isSend;
    private ItemFilter filter;

    public PacketItemFilter() {
    }

    public PacketItemFilter(TileTransceiver te, boolean isSend) {
        super(te);
        this.isSend = isSend;
        this.filter = isSend ? te.getSendItemFilter() : te.getReceiveItemFilter();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.isSend);
        NBTTagCompound tag = new NBTTagCompound();
        this.filter.writeToNBT(tag);
        NetworkUtil.writeNBTTagCompound(tag, buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.isSend = buf.readBoolean();
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound(buf);
        this.filter = new ItemFilter();
        this.filter.readFromNBT(tag);
    }

    public IMessage onMessage(PacketItemFilter message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileTransceiver tile = (TileTransceiver)message.getTileEntity(player.field_70170_p);
        boolean isSend = message.isSend;
        ItemFilter filter = message.filter;
        if (tile != null && filter != null) {
            if (isSend) {
                tile.setSendItemFilter(filter);
            } else {
                tile.setRecieveItemFilter(filter);
            }
        }
        return null;
    }
}

