/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.network.MessageTileEntity;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketSendRecieveChannelList
extends MessageTileEntity<TileTransceiver>
implements IMessageHandler<PacketSendRecieveChannelList, IMessage> {
    private boolean isSend;
    private EnumMap<ChannelType, List<Channel>> channels;

    public PacketSendRecieveChannelList() {
    }

    public PacketSendRecieveChannelList(TileTransceiver te, boolean isSend) {
        super(te);
        this.isSend = isSend;
        this.channels = isSend ? te.getSendChannels() : te.getReceiveChannels();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.isSend);
        NBTTagList tagList = TileTransceiver.createTagList(this.channels);
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a("chans", (NBTBase)tagList);
        NetworkUtil.writeNBTTagCompound(root, buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.isSend = buf.readBoolean();
        NBTTagCompound root = NetworkUtil.readNBTTagCompound(buf);
        this.channels = new EnumMap(ChannelType.class);
        for (ChannelType type : ChannelType.values()) {
            this.channels.put(type, new ArrayList());
        }
        TileTransceiver.readChannels(root, this.channels, "chans");
    }

    public IMessage onMessage(PacketSendRecieveChannelList message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileTransceiver tile = (TileTransceiver)message.getTileEntity(player.field_70170_p);
        if (tile != null) {
            if (message.isSend) {
                tile.setSendChannels(message.channels);
            } else {
                tile.setRecieveChannels(message.channels);
            }
        }
        return null;
    }
}

