/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VatRecipe
implements IRecipe {
    protected final FluidStack inputFluidStack;
    protected final List<ItemStack> inputStacks;
    protected final FluidStack outputFluidStack;
    protected final RecipeInput[] inputs;
    protected final RecipeOutput[] output;
    protected final int energyRequired;
    private int requiredItems;

    public VatRecipe(IRecipe recipe) {
        List<FluidStack> fluids = recipe.getInputFluidStacks();
        this.inputFluidStack = fluids != null && !fluids.isEmpty() ? fluids.get(0).copy() : null;
        FluidStack os = null;
        for (RecipeOutput output : recipe.getOutputs()) {
            if (!output.isFluid()) continue;
            os = output.getFluidOutput().copy();
            break;
        }
        this.outputFluidStack = os;
        this.inputStacks = recipe.getInputStacks();
        this.inputs = recipe.getInputs();
        this.output = new RecipeOutput[]{new RecipeOutput(this.outputFluidStack)};
        this.energyRequired = recipe.getEnergyRequired();
        this.requiredItems = 1;
        for (RecipeInput ri : this.inputs) {
            if (ri.isFluid() || ri.getSlotNumber() != 1) continue;
            this.requiredItems = 2;
        }
    }

    @Override
    public boolean isValid() {
        return this.inputFluidStack != null && this.inputStacks != null && !this.inputStacks.isEmpty() && this.inputStacks.size() > 0 && this.outputFluidStack != null;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public RecipeOutput[] getOutputs() {
        return this.output;
    }

    @Override
    public RecipeInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getInputStacks() {
        return this.inputStacks;
    }

    @Override
    public RecipeBonusType getBonusType() {
        return RecipeBonusType.NONE;
    }

    @Override
    public boolean isValidInput(int slot, ItemStack item) {
        if (item == null) {
            return false;
        }
        for (RecipeInput ri : this.inputs) {
            if (item == null || ri.getSlotNumber() != slot || !ri.isInput(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidInput(FluidStack item) {
        if (item == null) {
            return false;
        }
        for (RecipeInput ri : this.inputs) {
            if (item.getFluid() == null || !item.isFluidEqual(ri.getFluidInput())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInputForRecipe(MachineRecipeInput ... inputs) {
        if (!this.isValid() || inputs == null || inputs.length < 2) {
            return false;
        }
        int found = 0;
        for (MachineRecipeInput in : inputs) {
            if (in.isFluid()) {
                FluidStack needFluid = this.getRequiredFluidInput(inputs);
                boolean validFluid = needFluid.isFluidEqual(in.fluid);
                if (!validFluid || needFluid.amount > in.fluid.amount) continue;
                ++found;
                continue;
            }
            if (!this.isValidInput(in.slotNumber, in.item)) continue;
            ++found;
        }
        return found == this.requiredItems + 1;
    }

    @Override
    public List<FluidStack> getInputFluidStacks() {
        return Collections.singletonList(this.inputFluidStack);
    }

    public float getMultiplierForInput(FluidStack item) {
        for (RecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getMulitplier();
        }
        return 1.0f;
    }

    public FluidStack getRequiredFluidInput(MachineRecipeInput[] inputs) {
        float inputFluidMul = 1.0f;
        float outputFluidMul = 1.0f;
        FluidStack inputFluidStack = null;
        for (MachineRecipeInput ri : inputs) {
            if (!ri.isFluid()) {
                inputFluidMul *= this.getMultiplierForInput(ri.item);
                continue;
            }
            inputFluidStack = ri.fluid.copy();
        }
        inputFluidStack.amount = Math.round(inputFluidMul * 1000.0f);
        return inputFluidStack;
    }

    public FluidStack getFluidOutput(MachineRecipeInput ... inputs) {
        FluidStack outFluid = this.getOutputFluid().copy();
        float outMul = 1.0f;
        for (MachineRecipeInput ri : inputs) {
            outMul *= this.getMultiplierForInput(ri.item);
            outMul *= this.getMultiplierForInput(ri.fluid);
        }
        outFluid.amount = Math.round(outMul * 1000.0f);
        return outFluid;
    }

    public float getMultiplierForInput(ItemStack item) {
        for (RecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getMulitplier();
        }
        return 1.0f;
    }

    public int getNumConsumed(ItemStack item) {
        for (RecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getInput().field_77994_a;
        }
        return 1;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluidStack;
    }
}

