/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerDistributor {
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private final BlockCoord bc;

    public PowerDistributor(BlockCoord bc) {
        this.bc = bc;
    }

    public void neighboursChanged() {
        this.receptorsDirty = true;
    }

    public int transmitEnergy(World worldObj, int available) {
        int transmitted = 0;
        this.checkReceptors(worldObj);
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && available > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            if (pp != null && pp.getMinEnergyReceived(receptor.fromDir.getOpposite()) <= available) {
                int used = pp.recieveEnergy(receptor.fromDir.getOpposite(), available);
                transmitted += used;
                available -= used;
            }
            if (available <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        return transmitted;
    }

    private void checkReceptors(World worldObj) {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity transmitter = worldObj.func_147438_o(this.bc.x, this.bc.y, this.bc.z);
            if (transmitter instanceof AbstractMachineEntity && !((AbstractMachineEntity)transmitter).getIoMode(dir).canOutput()) continue;
            BlockCoord checkLoc = this.bc.getLocation(dir);
            TileEntity te = worldObj.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
            IPowerInterface pi = PowerHandlerUtil.create(te);
            if (pi == null || !pi.canConduitConnect(dir.getOpposite())) continue;
            this.receptors.add(new Receptor(pi, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    static class Receptor {
        IPowerInterface receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerInterface rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

