/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.gui.CheckBoxEIO;
import crazypants.enderio.gui.IGuiOverlay;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketLabel;
import crazypants.gui.GuiContainerBase;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiTravelAccessable
extends GuiContainerBase {
    private static final int ID_PUBLIC = 0;
    private static final int ID_PRIVATE = 1;
    private static final int ID_PROTECTED = 2;
    private CheckBoxEIO publicCB;
    private CheckBoxEIO privateCB;
    private CheckBoxEIO protectedCB;
    private GuiTextField tf;
    private String publicStr;
    private String privateStr;
    private String protectedStr;
    private ITravelAccessable te;
    private int col0x;
    private int col1x;
    private int col2x;
    private World world;

    public GuiTravelAccessable(InventoryPlayer playerInv, ITravelAccessable te, World world) {
        super(new ContainerTravelAccessable(playerInv, te, world));
        this.te = te;
        this.world = world;
        this.publicStr = Lang.localize("gui.travelAccessable.public");
        this.privateStr = Lang.localize("gui.travelAccessable.private");
        this.protectedStr = Lang.localize("gui.travelAccessable.protected");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.tf = new GuiTextField(fr, 7, 12, 90, 16);
        this.col1x = 88;
        this.col0x = (this.col1x - fr.func_78256_a(this.protectedStr) / 2) / 2;
        this.col2x = this.col1x + fr.func_78256_a(this.protectedStr) / 2;
        this.col2x += (176 - this.col2x) / 2;
        int x = 0;
        int y = 50;
        x = this.col0x - 8;
        this.privateCB = new CheckBoxEIO(this, 1, x, y);
        this.privateCB.setSelected(te.getAccessMode() == TileTravelAnchor.AccessMode.PRIVATE);
        x = this.col1x - 8;
        this.protectedCB = new CheckBoxEIO(this, 2, x, y);
        this.protectedCB.setSelected(te.getAccessMode() == TileTravelAnchor.AccessMode.PROTECTED);
        x = this.col2x - 8;
        this.publicCB = new CheckBoxEIO(this, 0, x, y);
        this.publicCB.setSelected(te.getAccessMode() == TileTravelAnchor.AccessMode.PUBLIC);
        this.field_147000_g = 185;
    }

    protected void func_146284_a(GuiButton b) {
        this.privateCB.setSelected(b.field_146127_k == 1);
        this.protectedCB.setSelected(b.field_146127_k == 2);
        this.publicCB.setSelected(b.field_146127_k == 0);
        TileTravelAnchor.AccessMode curMode = b.field_146127_k == 1 ? TileTravelAnchor.AccessMode.PRIVATE : (b.field_146127_k == 2 ? TileTravelAnchor.AccessMode.PROTECTED : TileTravelAnchor.AccessMode.PUBLIC);
        this.te.setAccessMode(curMode);
        BlockCoord bc = this.te.getLocation();
        PacketAccessMode p = new PacketAccessMode(bc.x, bc.y, bc.z, curMode);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.publicCB.setPaintSelectedBorder(false);
        this.publicCB.onGuiInit();
        this.privateCB.onGuiInit();
        this.protectedCB.onGuiInit();
        this.tf.field_146209_f = this.getGuiLeft() + 30;
        this.tf.field_146210_g = this.getGuiTop() + 10;
        this.tf.func_146205_d(false);
        this.tf.func_146203_f(32);
        this.tf.func_146195_b(true);
        String txt = this.te.getLabel();
        if (txt != null && txt.length() > 0) {
            this.tf.func_146180_a(txt);
        }
    }

    @Override
    public void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            for (IGuiOverlay overlay : this.overlays) {
                if (!overlay.isVisible()) continue;
                overlay.setVisible(false);
                return;
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.tf.func_146201_a(par1, par2);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.tf.func_146178_a();
    }

    public void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        this.tf.func_146192_a(x, y, par3);
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/travelAccessable.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int col = ColorUtil.getRGB(Color.white);
        int x = sx;
        int y = sy + 38;
        FontRenderer fontRenderer = this.getFontRenderer();
        x = sx + this.col0x - fontRenderer.func_78256_a(this.privateStr) / 2;
        fontRenderer.func_78261_a(this.privateStr, x, y, col);
        x = sx + this.col1x - fontRenderer.func_78256_a(this.protectedStr) / 2;
        fontRenderer.func_78261_a(this.protectedStr, x, y, col);
        x = sx + this.col2x - fontRenderer.func_78256_a(this.publicStr) / 2;
        fontRenderer.func_78261_a(this.publicStr, x, y, col);
        this.tf.func_146194_f();
        this.checkLabelForChange();
    }

    private void checkLabelForChange() {
        String curText;
        String newTxt = this.tf.func_146179_b();
        if (newTxt != null && newTxt.length() == 0) {
            newTxt = null;
        }
        if ((curText = this.te.getLabel()) != null && curText.length() == 0) {
            curText = null;
        }
        boolean changed = false;
        if (newTxt == null) {
            changed = curText != null;
        } else {
            boolean bl = changed = !newTxt.equals(curText);
        }
        if (!changed) {
            return;
        }
        this.te.setLabel(newTxt);
        BlockCoord bc = this.te.getLocation();
        PacketLabel p = new PacketLabel(bc.x, bc.y, bc.z, this.te.getLabel());
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    @Override
    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.drawForegroundImpl(mouseX, mouseY);
        if (this.te.getAccessMode() != TileTravelAnchor.AccessMode.PROTECTED) {
            int sx = (this.field_146294_l - this.field_146999_f) / 2;
            int sy = (this.field_146295_m - this.field_147000_g) / 2;
            RenderUtil.bindTexture("enderio:textures/gui/travelAccessable.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2929);
            this.func_73729_b(43, 72, 5, 35, 90, 18);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
    }
}

