/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import crazypants.enderio.config.Config;

public enum TravelSource {
    BLOCK(0.0f, Config.travelAnchorMaxDistance),
    STAFF(Config.travelStaffPowerPerBlockRF, Config.travelStaffMaxDistance),
    STAFF_BLINK(Config.travelStaffPowerPerBlockRF, Config.travelStaffMaxBlinkDistance);

    public final float powerCostPerBlockTraveledRF;
    public final int maxDistanceTravelled;
    public final int maxDistanceTravelledSq;

    public static int getMaxDistance() {
        return TravelSource.STAFF.maxDistanceTravelledSq;
    }

    public static int getMaxDistanceSq() {
        return TravelSource.STAFF.maxDistanceTravelledSq;
    }

    private TravelSource(float powerCostPerBlockTraveled, int maxDistanceTravelled) {
        this.powerCostPerBlockTraveledRF = powerCostPerBlockTraveled;
        this.maxDistanceTravelled = maxDistanceTravelled;
        this.maxDistanceTravelledSq = maxDistanceTravelled * maxDistanceTravelled;
    }

    public boolean getConserveMomentum() {
        return this == STAFF_BLINK;
    }
}

