/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.BoundingBox;
import crazypants.render.ColorUtil;
import crazypants.render.IConnectedTextureRenderer;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vector4d;
import crazypants.vecmath.Vector4f;
import crazypants.vecmath.Vertex;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static final Vector4f DEFAULT_TEXT_SHADOW_COL = new Vector4f(0.33f, 0.33f, 0.33f, 0.33f);
    public static final Vector4f DEFAULT_TXT_COL = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Vector4f DEFAULT_TEXT_BG_COL = new Vector4f(0.275f, 0.08f, 0.4f, 0.75f);
    public static final Vector3d UP_V = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZERO_V = new Vector3d(0.0, 0.0, 0.0);
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;
    public static final ResourceLocation ITEM_TEX = TextureMap.field_110576_c;
    public static final ResourceLocation GLINT_TEX = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static int BRIGHTNESS_MAX = 0xF000F0;

    public static void loadMatrix(Matrix4d mat) {
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.put((float)mat.m00);
        MATRIX_BUFFER.put((float)mat.m01);
        MATRIX_BUFFER.put((float)mat.m02);
        MATRIX_BUFFER.put((float)mat.m03);
        MATRIX_BUFFER.put((float)mat.m10);
        MATRIX_BUFFER.put((float)mat.m11);
        MATRIX_BUFFER.put((float)mat.m12);
        MATRIX_BUFFER.put((float)mat.m13);
        MATRIX_BUFFER.put((float)mat.m20);
        MATRIX_BUFFER.put((float)mat.m21);
        MATRIX_BUFFER.put((float)mat.m22);
        MATRIX_BUFFER.put((float)mat.m23);
        MATRIX_BUFFER.put((float)mat.m30);
        MATRIX_BUFFER.put((float)mat.m31);
        MATRIX_BUFFER.put((float)mat.m32);
        MATRIX_BUFFER.put((float)mat.m33);
        MATRIX_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindItemTexture(ItemStack stack) {
        RenderUtil.engine().func_110577_a(stack.func_94608_d() == 0 ? BLOCK_TEX : ITEM_TEX);
    }

    public static void bindItemTexture() {
        RenderUtil.engine().func_110577_a(ITEM_TEX);
    }

    public static void bindBlockTexture() {
        RenderUtil.engine().func_110577_a(BLOCK_TEX);
    }

    public static void bindGlintTexture() {
        RenderUtil.engine().func_110577_a(BLOCK_TEX);
    }

    public static void bindTexture(String string) {
        RenderUtil.engine().func_110577_a(new ResourceLocation(string));
    }

    public static void bindTexture(ResourceLocation tex) {
        RenderUtil.engine().func_110577_a(tex);
    }

    public static FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static float[] getDefaultPerSideBrightness() {
        float[] brightnessPerSide = new float[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
        }
        return brightnessPerSide;
    }

    public static IIcon[] getBlockTextures(Block block, int meta) {
        IIcon[] icons = new IIcon[6];
        int i = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            icons[i] = block.func_149691_a(dir.ordinal(), meta);
            ++i;
        }
        return icons;
    }

    public static IIcon[] getBlockTextures(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        IIcon[] icons = new IIcon[6];
        int i = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            icons[i] = block.func_149673_e(world, x, y, z, dir.ordinal());
            ++i;
        }
        return icons;
    }

    public static float claculateTotalBrightnessForLocation(World worldObj, int xCoord, int yCoord, int zCoord) {
        int i = worldObj.func_72802_i(xCoord, yCoord, zCoord, 0);
        int j = i % 65536;
        int k = i / 65536;
        float minLight = 0.0f;
        float sunBrightness = worldObj.func_72971_b(1.0f);
        float percentRecievedFromSun = (float)k / 255.0f;
        float fromLights = (float)j / 255.0f;
        float recievedPercent = worldObj.func_72801_o(xCoord, yCoord, zCoord);
        float highestValue = Math.max(fromLights, percentRecievedFromSun * sunBrightness);
        return Math.max(0.2f, highestValue);
    }

    public static float getColorMultiplierForFace(ForgeDirection face) {
        if (face == ForgeDirection.UP) {
            return 1.0f;
        }
        if (face == ForgeDirection.DOWN) {
            return 0.5f;
        }
        if (face.offsetX != 0) {
            return 0.6f;
        }
        return 0.8f;
    }

    public static int setTesselatorBrightness(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int res = block == null ? world.func_72802_i(x, y, z, 0) : block.func_149677_c(world, x, y, z);
        Tessellator.field_78398_a.func_78380_c(res);
        Tessellator.field_78398_a.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        return res;
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, int colorRGB) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(colorRGB);
        tessellator.func_78377_a(x, y + height, z);
        tessellator.func_78377_a(x + width, y + height, z);
        tessellator.func_78377_a(x + width, y, z);
        tessellator.func_78377_a(x, y, z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, Vector4f colorRGBA) {
        GL11.glColor4f((float)colorRGBA.x, (float)colorRGBA.y, (float)colorRGBA.z, (float)colorRGBA.w);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(x, y + height, z);
        tessellator.func_78377_a(x + width, y + height, z);
        tessellator.func_78377_a(x + width, y, z);
        tessellator.func_78377_a(x, y, z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static Matrix4d createBillboardMatrix(TileEntity te, EntityLivingBase entityPlayer) {
        return RenderUtil.createBillboardMatrix(new Vector3d((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5), entityPlayer);
    }

    public static Matrix4d createBillboardMatrix(Vector3d lookAt, EntityLivingBase entityPlayer) {
        Vector3d playerEye = new Vector3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + 1.62 - (double)entityPlayer.field_70129_M, entityPlayer.field_70161_v);
        Vector3d blockOrigin = new Vector3d(lookAt.x, lookAt.y, lookAt.z);
        Matrix4d lookMat = VecmathUtil.createMatrixAsLookAt(blockOrigin, playerEye, UP_V);
        lookMat.setTranslation(new Vector3d());
        lookMat.invert();
        return lookMat;
    }

    public static void renderBillboard(Matrix4d lookMat, float minU, float maxU, float minV, float maxV, double size, int brightness) {
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78380_c(brightness);
        double s = size / 2.0;
        Vector3d v = new Vector3d();
        v.set(-s, s, 0.0);
        lookMat.transform(v);
        tes.func_78374_a(v.x, v.y, v.z, (double)minU, (double)maxV);
        v.set(s, s, 0.0);
        lookMat.transform(v);
        tes.func_78374_a(v.x, v.y, v.z, (double)maxU, (double)maxV);
        v.set(s, -s, 0.0);
        lookMat.transform(v);
        tes.func_78374_a(v.x, v.y, v.z, (double)maxU, (double)minV);
        v.set(-s, -s, 0.0);
        lookMat.transform(v);
        tes.func_78374_a(v.x, v.y, v.z, (double)minU, (double)minV);
        tes.func_78381_a();
    }

    public static List<ForgeDirection> getEdgesForFace(ForgeDirection face) {
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>(4);
        if (face.offsetY != 0) {
            result.add(ForgeDirection.NORTH);
            result.add(ForgeDirection.EAST);
            result.add(ForgeDirection.SOUTH);
            result.add(ForgeDirection.WEST);
        } else if (face.offsetX != 0) {
            result.add(ForgeDirection.DOWN);
            result.add(ForgeDirection.SOUTH);
            result.add(ForgeDirection.UP);
            result.add(ForgeDirection.NORTH);
        } else {
            result.add(ForgeDirection.DOWN);
            result.add(ForgeDirection.WEST);
            result.add(ForgeDirection.UP);
            result.add(ForgeDirection.EAST);
        }
        return result;
    }

    public static void addVerticesToTesselator(List<Vertex> vertices) {
        RenderUtil.addVerticesToTessellator(vertices, Tessellator.field_78398_a);
    }

    public static void addVerticesToTessellator(List<Vertex> vertices, Tessellator tes) {
        for (Vertex v : vertices) {
            if (v.brightness != -1) {
                tes.func_78380_c(v.brightness);
            }
            if (v.color != null) {
                tes.func_78369_a(v.r(), v.g(), v.b(), v.a());
            }
            if (v.uv != null) {
                tes.func_78385_a((double)v.u(), (double)v.v());
            }
            if (v.normal != null) {
                tes.func_78375_b(v.nx(), v.ny(), v.nz());
            }
            tes.func_78377_a(v.x(), v.y(), v.z());
        }
    }

    public static void renderConnectedTextureFace(IBlockAccess blockAccess, Block block, int x, int y, int z, ForgeDirection face, IIcon texture, boolean forceAllEdges) {
        RenderUtil.renderConnectedTextureFace(blockAccess, block, x, y, z, face, texture, forceAllEdges, true, true);
    }

    public static void renderConnectedTextureFace(IBlockAccess blockAccess, Block block, int x, int y, int z, ForgeDirection face, IIcon texture, boolean forceAllEdges, boolean translateToXYZ, boolean applyFaceShading) {
        if (blockAccess == null && !forceAllEdges || face == null || texture == null) {
            return;
        }
        if (!forceAllEdges) {
            Block check = blockAccess.func_147439_a(x, y, z);
            if (check == null) {
                return;
            }
            if (!check.func_149646_a(blockAccess, x + face.offsetX, y + face.offsetY, z + face.offsetZ, face.ordinal())) {
                return;
            }
        }
        BlockCoord bc = new BlockCoord(x, y, z);
        List<ForgeDirection> edges = forceAllEdges ? RenderUtil.getEdgesForFace(face) : RenderUtil.getNonConectedEdgesForFace(blockAccess, x, y, z, face);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78375_b((float)face.offsetX, (float)face.offsetY, (float)face.offsetZ);
        if (applyFaceShading) {
            float cm = RenderUtil.getColorMultiplierForFace(face);
            tes.func_78386_a(cm, cm, cm);
        }
        float scaleFactor = 0.9375f;
        Vector2f uv = new Vector2f();
        for (ForgeDirection edge : edges) {
            float xLen = 1.0f - (float)Math.abs(edge.offsetX) * scaleFactor;
            float yLen = 1.0f - (float)Math.abs(edge.offsetY) * scaleFactor;
            float zLen = 1.0f - (float)Math.abs(edge.offsetZ) * scaleFactor;
            xLen = (float)((double)xLen - (2.0 * (1.0 - block.func_149753_y()) - block.func_149704_x()));
            yLen = (float)((double)yLen - (2.0 * (1.0 - block.func_149669_A()) - block.func_149665_z()));
            zLen = (float)((double)zLen - (2.0 * (1.0 - block.func_149693_C()) - block.func_149706_B()));
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(xLen, yLen, zLen);
            List<Vector3f> corners = bb.getCornersForFace(face);
            for (Vector3f unitCorn : corners) {
                Vector3d corner = new Vector3d(unitCorn);
                if (translateToXYZ) {
                    corner.x += (double)x;
                    corner.y += (double)y;
                    corner.z += (double)z;
                }
                corner.x += (double)((float)((double)edge.offsetX * 0.5) - Math.signum(edge.offsetX) * xLen / 2.0f);
                corner.y += (double)((float)((double)edge.offsetY * 0.5) - Math.signum(edge.offsetY) * yLen / 2.0f);
                corner.z += (double)((float)((double)edge.offsetZ * 0.5) - Math.signum(edge.offsetZ) * zLen / 2.0f);
                if (translateToXYZ) {
                    RenderUtil.getUvForCorner(uv, corner, x, y, z, face, texture);
                } else {
                    RenderUtil.getUvForCorner(uv, corner, 0, 0, 0, face, texture);
                }
                tes.func_78374_a(corner.x, corner.y, corner.z, (double)uv.x, (double)uv.y);
            }
        }
    }

    public static List<ForgeDirection> getNonConectedEdgesForFace(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection face) {
        return RenderUtil.getNonConectedEdgesForFace(blockAccess, x, y, z, face, null);
    }

    public static List<ForgeDirection> getNonConectedEdgesForFace(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection face, IConnectedTextureRenderer render) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block == null) {
            return Collections.emptyList();
        }
        if (!block.func_149646_a(blockAccess, x + face.offsetX, y + face.offsetY, z + face.offsetZ, face.ordinal())) {
            return Collections.emptyList();
        }
        BlockCoord bc = new BlockCoord(x, y, z);
        ArrayList<EdgeNeighbour> edges = new ArrayList<EdgeNeighbour>(4);
        for (ForgeDirection dir : RenderUtil.getEdgesForFace(face)) {
            edges.add(new EdgeNeighbour(bc, dir));
        }
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>(4);
        for (EdgeNeighbour edge : edges) {
            boolean matchingNeighbour;
            boolean bl = matchingNeighbour = blockAccess.func_147439_a(edge.bc.x, edge.bc.y, edge.bc.z) == block;
            if (matchingNeighbour && render != null) {
                matchingNeighbour = render.matchesMetadata(blockAccess.func_72805_g(x, y, z), blockAccess.func_72805_g(edge.bc.x, edge.bc.y, edge.bc.z));
            }
            if (matchingNeighbour) continue;
            result.add(edge.dir);
        }
        return result;
    }

    public static void getUvForCorner(Vector2f uv, Vector3d corner, int x, int y, int z, ForgeDirection face, IIcon icon) {
        if (icon == null) {
            return;
        }
        Vector3d p = new Vector3d(corner);
        p.x -= (double)x;
        p.y -= (double)y;
        p.z -= (double)z;
        float uWidth = 1.0f;
        float vWidth = 1.0f;
        if (icon != null) {
            uWidth = icon.func_94212_f() - icon.func_94209_e();
            vWidth = icon.func_94210_h() - icon.func_94206_g();
        }
        uv.x = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getUPlaneForFace(face), p);
        uv.y = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getVPlaneForFace(face), p);
        if (icon != null) {
            uv.x = icon.func_94209_e() + uv.x * uWidth;
            uv.y = icon.func_94206_g() + uv.y * vWidth;
        }
    }

    public static Vector4d getVPlaneForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return new Vector4d(0.0, -1.0, 0.0, 1.0);
            }
        }
        return null;
    }

    public static Vector4d getUPlaneForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
            case EAST: {
                return new Vector4d(0.0, 0.0, -1.0, 1.0);
            }
            case WEST: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case NORTH: {
                return new Vector4d(-1.0, 0.0, 0.0, 1.0);
            }
            case SOUTH: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
        }
        return null;
    }

    public static ForgeDirection getVDirForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return ForgeDirection.SOUTH;
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.UP;
            }
        }
        return null;
    }

    public static ForgeDirection getUDirForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
        }
        return null;
    }

    public static void renderGuiTank(FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderUtil.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        IIcon icon = fluid.getFluid().getStillIcon();
        if (icon == null && (icon = fluid.getFluid().getIcon()) == null) {
            return;
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderUtil.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GL11.glEnable((int)3042);
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GL11.glDisable((int)3042);
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, DEFAULT_TEXT_BG_COL);
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size, Vector4f bgCol) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, bgCol);
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size, Vector4f txtCol, boolean drawShadow, Vector4f shadowCol, boolean drawBackground, Vector4f bgCol) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer fnt = Minecraft.func_71410_x().field_71466_p;
        float scale = size / (float)fnt.field_78288_b;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)(RenderManager.field_78727_a.field_78735_i + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-fnt.func_78256_a(text) / 2), (float)0.0f, (float)0.0f);
        if (drawBackground) {
            RenderUtil.renderBackground(fnt, text, bgCol);
        }
        fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(txtCol));
        if (drawShadow) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.1f);
            fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(shadowCol));
        }
        GL11.glPopMatrix();
        RenderUtil.bindBlockTexture();
    }

    public static void renderBackground(FontRenderer fnt, String toRender, Vector4f color) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float width = fnt.func_78256_a(toRender);
        float height = fnt.field_78288_b;
        float padding = 2.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(color.x, color.y, color.z, color.w);
        tessellator.func_78377_a((double)(-padding), (double)(-padding), 0.0);
        tessellator.func_78377_a((double)(-padding), (double)(height + padding), 0.0);
        tessellator.func_78377_a((double)(width + padding), (double)(height + padding), 0.0);
        tessellator.func_78377_a((double)(width + padding), (double)(-padding), 0.0);
        tessellator.func_78381_a();
        GL11.glPopAttrib();
    }

    public static void registerReloadListener(IResourceManagerReloadListener obj) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(obj);
    }

    private static class EdgeNeighbour {
        final ForgeDirection dir;
        final BlockCoord bc;

        public EdgeNeighbour(BlockCoord bc, ForgeDirection dir) {
            this.dir = dir;
            this.bc = bc.getLocation(dir);
        }
    }
}

