/*
 * Decompiled with CFR 0.152.
 */
package EmeraldMod.entity.tileentity;

import EmeraldMod.EmeraldMod;
import EmeraldMod.blocks.EMBlockFurnace;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;

public class EMTileEntityFurnace
extends TileEntity
implements ISidedInventory {
    private String localizedName = EnumChatFormatting.DARK_GREEN + "Emerald Furnace";
    private String field_145958_o;
    private ItemStack[] slots = new ItemStack[3];
    public int furnaceSpeed = EmeraldMod.furnaceSpeed;
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[0];

    public int func_70302_i_() {
        return this.slots.length;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookTime * par1 / this.furnaceSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.furnaceSpeed;
        }
        return this.burnTime * par1 / this.currentItemBurnTime;
    }

    public void setGuiDisplayName(String displayName) {
        this.localizedName = displayName;
    }

    public boolean isInvNameLocalized() {
        return this.localizedName != null && this.localizedName.length() > 0;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.burnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.cookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = EMTileEntityFurnace.getItemBurnTime(this.slots[1]);
        if (par1NBTTagCompound.func_74764_b("CustomName")) {
            this.localizedName = par1NBTTagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.burnTime);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.cookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.isInvNameLocalized()) {
            par1NBTTagCompound.func_74778_a("CustomName", this.localizedName);
        }
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemstack = this.slots[i];
                this.slots[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_145845_h() {
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K && this.burnTime == 0 && this.canSmelt()) {
            this.currentItemBurnTime = this.burnTime = EMTileEntityFurnace.getItemBurnTime(this.slots[1]);
            if (this.burnTime > 0) {
                flag1 = true;
                if (this.slots[1] != null) {
                    --this.slots[1].field_77994_a;
                    if (this.slots[1].field_77994_a == 0) {
                        this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                    }
                }
            }
            if (flag != this.burnTime > 0) {
                EMBlockFurnace.updateFurnaceBlockState(this.burnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.cookTime;
            if (this.cookTime == this.furnaceSpeed) {
                this.cookTime = 0;
                this.smeltItem();
                flag1 = true;
            }
        } else {
            this.cookTime = 0;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void something(String p_145951_1_) {
        this.field_145958_o = p_145951_1_;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (this.slots[2] == null) {
                this.slots[2] = itemstack.func_77946_l();
            } else if (this.slots[2].func_77969_a(itemstack)) {
                this.slots[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
        }
    }

    private boolean canSmelt() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.slots[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemstack = this.slots[i];
            this.slots[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 2 ? false : (i == 1 ? EMTileEntityFurnace.isItemFuel(itemstack) : true);
    }

    public static boolean isItemFuel(ItemStack itemstack) {
        return EMTileEntityFurnace.getItemBurnTime(itemstack) > 0;
    }

    public static int getItemBurnTime(ItemStack p_145952_0_) {
        if (p_145952_0_ == null) {
            return 0;
        }
        Item item = p_145952_0_.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 300;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 600;
            }
            if (block == Blocks.field_150402_ci) {
                return 32000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 400;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 400;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 400;
        }
        if (item == Items.field_151055_y) {
            return 200;
        }
        if (item == Items.field_151044_h) {
            return 3200;
        }
        if (item == Items.field_151129_at) {
            return 40000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 200;
        }
        if (item == Items.field_151072_bj) {
            return 4800;
        }
        return GameRegistry.getFuelValue((ItemStack)p_145952_0_);
    }

    public int[] func_94128_d(int var1) {
        return var1 == 0 ? slots_bottom : (var1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return j != 0 || i != 1 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public String func_145825_b() {
        return this.isInvNameLocalized() ? this.localizedName : "container.emeraldFurnace";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

