/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.tools.PEToolBase;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class RedStar
extends PEToolBase {
    public RedStar() {
        super("rm_morning_star", (byte)4, new String[]{StatCollector.func_74838_a((String)"pe.morningstar.mode1"), StatCollector.func_74838_a((String)"pe.morningstar.mode2"), StatCollector.func_74838_a((String)"pe.morningstar.mode3"), StatCollector.func_74838_a((String)"pe.morningstar.mode4")});
        this.setNoRepair();
        this.peToolMaterial = "rm_tools";
        this.pePrimaryToolClass = "morning_star";
        this.harvestMaterials.add(Material.field_151577_b);
        this.harvestMaterials.add(Material.field_151578_c);
        this.harvestMaterials.add(Material.field_151595_p);
        this.harvestMaterials.add(Material.field_151597_y);
        this.harvestMaterials.add(Material.field_151571_B);
        this.harvestMaterials.add(Material.field_151573_f);
        this.harvestMaterials.add(Material.field_151574_g);
        this.harvestMaterials.add(Material.field_151576_e);
        this.harvestMaterials.add(Material.field_151575_d);
        this.harvestMaterials.add(Material.field_151585_k);
        this.harvestMaterials.add(Material.field_151582_l);
        this.secondaryClasses.add("pickaxe");
        this.secondaryClasses.add("chisel");
        this.secondaryClasses.add("shovel");
        this.secondaryClasses.add("axe");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager) {
        boolean flag = ProjectEConfig.useOldDamage;
        this.attackWithCharge(stack, damaged, damager, flag ? 20.0f : 1.0f);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase eLiving) {
        this.digBasedOnMode(stack, world, block, x, y, z, eLiving);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition mop;
            if (ProjectEConfig.pickaxeAoeVeinMining) {
                this.mineOreVeinsInAOE(stack, player);
            }
            if ((mop = this.func_77621_a(world, player, true)) == null) {
                return stack;
            }
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                Block block = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (block instanceof BlockGravel || block instanceof BlockClay) {
                    if (ProjectEConfig.pickaxeAoeVeinMining) {
                        this.digAOE(stack, world, player, false, 0);
                    } else {
                        this.tryVeinMine(stack, player, mop);
                    }
                } else if (ItemHelper.isOre(block, world.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d))) {
                    if (!ProjectEConfig.pickaxeAoeVeinMining) {
                        this.tryVeinMine(stack, player, mop);
                    }
                } else if (block instanceof BlockGrass || block instanceof BlockDirt || block instanceof BlockSand) {
                    this.digAOE(stack, world, player, false, 0);
                } else {
                    this.digAOE(stack, world, player, true, 0);
                }
            }
        }
        return stack;
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int metadata) {
        if (block == ObjHandler.matterBlock || block == ObjHandler.dmFurnaceOff || block == ObjHandler.dmFurnaceOn || block == ObjHandler.rmFurnaceOff || block == ObjHandler.rmFurnaceOn) {
            return 1200000.0f;
        }
        return super.getDigSpeed(stack, block, metadata) + 48.0f;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        if (ProjectEConfig.useOldDamage) {
            return super.getAttributeModifiers(stack);
        }
        byte charge = stack.field_77990_d == null ? (byte)0 : this.getCharge(stack);
        float damage = 20.0f + (float)charge;
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, 0));
        return multimap;
    }
}

