/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.MineTweaker;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapedKleinStar;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessHidden;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.projecte.KleinStar")
public class KleinStar {
    @ZenMethod
    public static void addShaped(IItemStack output, IItemStack[][] inputs) {
        KleinStar.addRecipe(output, inputs, true);
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IItemStack[] inputs) {
        KleinStar.addRecipe(output, new IItemStack[][]{inputs}, false);
    }

    private static void addRecipe(IItemStack output, IItemStack[][] inputs, boolean shaped) {
        ItemStack outputStack = MineTweakerMC.getItemStack((IItemStack)output);
        if (outputStack.func_77973_b() == ObjHandler.kleinStars) {
            if (shaped && inputs.length != 3) {
                MineTweakerAPI.logError((String)"Unable to add recipe with input rows other than 3");
                return;
            }
            ArrayList<ItemStack> isInputs = new ArrayList<ItemStack>();
            IItemStack[][] arr$ = inputs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                IItemStack[] input;
                for (IItemStack stack : input = arr$[i$]) {
                    isInputs.add(MineTweakerMC.getItemStack((IItemStack)stack));
                }
            }
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputStack, isInputs.toArray(new ItemStack[0]), shaped));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(output));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        IRecipe recipe = null;
        ItemStack remove;

        public RemoveRecipeAction(IItemStack rem) {
            this.remove = MineTweakerMC.getItemStack((IItemStack)rem);
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof RecipeShapelessHidden) || !this.remove.func_77969_a(irecipe.func_77571_b())) continue;
                this.recipe = irecipe;
            }
        }

        public void apply() {
            CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            CraftingManager.func_77594_a().func_77592_b().add(this.recipe);
        }

        public String describe() {
            return "Removing recipe for " + this.recipe.func_77571_b().func_82833_r() + " in a " + this.recipe.getClass();
        }

        public String describeUndo() {
            return "Un-removing recipe for " + this.recipe.func_77571_b().func_82833_r() + " in a " + this.recipe.getClass();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ItemStack output;
        private final ItemStack[] inputs;
        private final boolean shaped;
        IRecipe recipe;

        public AddRecipeAction(ItemStack outputStack, ItemStack[] inputs, boolean shaped) {
            this.output = outputStack;
            this.inputs = inputs;
            this.shaped = shaped;
        }

        public void apply() {
            this.recipe = this.shaped ? new RecipeShapedKleinStar(3, 3, this.inputs, this.output) : new RecipeShapelessHidden(this.output, (Object[])this.inputs);
            GameRegistry.addRecipe((IRecipe)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        }

        public String describe() {
            return "Adding recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

