/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLootBall;
import moze_intel.projecte.utils.CollectionHelper;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.NovaExplosion;
import moze_intel.projecte.utils.PELogger;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ExplosionEvent;

public final class WorldHelper {
    public static final ImmutableList<Class<? extends EntityLiving>> peacefuls = ImmutableList.of(EntitySheep.class, EntityPig.class, EntityCow.class, EntityMooshroom.class, EntityChicken.class, EntityBat.class, EntityVillager.class, EntitySquid.class, EntityOcelot.class, EntityWolf.class, EntityHorse.class);
    public static final ImmutableList<Class<? extends EntityLiving>> mobs = ImmutableList.of(EntityZombie.class, EntitySkeleton.class, EntityCreeper.class, EntitySpider.class, EntityEnderman.class, EntitySilverfish.class, EntityPigZombie.class, EntityGhast.class, EntityBlaze.class, EntitySlime.class, EntityWitch.class);
    public static Set<Class<? extends Entity>> interdictionBlacklist = Sets.newHashSet();
    public static Set<Class<? extends Entity>> swrgBlacklist = Sets.newHashSet();

    public static boolean blacklistInterdiction(Class<? extends Entity> clazz) {
        if (!interdictionBlacklist.contains(clazz)) {
            interdictionBlacklist.add(clazz);
            return true;
        }
        return false;
    }

    public static boolean blacklistSwrg(Class<? extends Entity> clazz) {
        if (!interdictionBlacklist.contains(clazz)) {
            interdictionBlacklist.add(clazz);
            return true;
        }
        return false;
    }

    public static void createLootDrop(List<ItemStack> drops, World world, double x, double y, double z) {
        if (drops.isEmpty()) {
            return;
        }
        ItemHelper.compactItemList(drops);
        if (ProjectEConfig.useLootBalls) {
            world.func_72838_d((Entity)new EntityLootBall(world, drops, x, y, z));
        } else {
            for (ItemStack drop : drops) {
                WorldHelper.spawnEntityItem(world, drop, x, y, z);
            }
        }
    }

    public static void createNovaExplosion(World world, Entity exploder, double x, double y, double z, float power) {
        NovaExplosion explosion = new NovaExplosion(world, exploder, x, y, z, power);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(world, (Explosion)explosion))) {
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
    }

    public static void extinguishNearby(World world, EntityPlayer player) {
        int x = (int)(player.field_70165_t - 1.0);
        while ((double)x <= player.field_70165_t + 1.0) {
            int y = (int)(player.field_70163_u - 1.0);
            while ((double)y <= player.field_70163_u + 1.0) {
                int z = (int)(player.field_70161_v - 1.0);
                while ((double)z <= player.field_70161_v + 1.0) {
                    if (world.func_147439_a(x, y, z) == Blocks.field_150480_ab && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                        world.func_147468_f(x, y, z);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void freezeInBoundingBox(World world, AxisAlignedBB box, EntityPlayer player, boolean random) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    Block b2;
                    Block b = world.func_147439_a(x, y, z);
                    if (!(b != Blocks.field_150355_j && b != Blocks.field_150358_i || random && world.field_73012_v.nextInt(128) != 0)) {
                        if (player != null) {
                            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y, z, Blocks.field_150432_aD, 0);
                        } else {
                            world.func_147449_b(x, y, z, Blocks.field_150432_aD);
                        }
                    } else if (b.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP) && (b2 = world.func_147439_a(x, y + 1, z)) == Blocks.field_150350_a && (!random || world.field_73012_v.nextInt(128) == 0)) {
                        if (player != null) {
                            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y + 1, z, Blocks.field_150431_aC, 0);
                        } else {
                            world.func_147449_b(x, y + 1, z, Blocks.field_150431_aC);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static List<TileEntity> getAdjacentTileEntities(World world, TileEntity tile) {
        return ImmutableList.copyOf(WorldHelper.getAdjacentTileEntitiesMapped(world, tile).values());
    }

    public static Map<ForgeDirection, TileEntity> getAdjacentTileEntitiesMapped(World world, TileEntity tile) {
        EnumMap<ForgeDirection, TileEntity> ret = new EnumMap<ForgeDirection, TileEntity>(ForgeDirection.class);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity candidate = world.func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
            if (candidate == null) continue;
            ret.put(dir, candidate);
        }
        return ret;
    }

    public static ArrayList<ItemStack> getBlockDrops(World world, EntityPlayer player, Block block, ItemStack stack, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0 && block.canSilkHarvest(world, player, x, y, z, meta)) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(block, 1, meta)});
        }
        return block.getDrops(world, x, y, z, meta, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
    }

    public static AxisAlignedBB getBroadDeepBox(Coordinates coords, ForgeDirection direction, int offset) {
        if (direction.offsetX > 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)(coords.y - offset), (double)(coords.z - offset), (double)coords.x, (double)(coords.y + offset), (double)(coords.z + offset));
        }
        if (direction.offsetX < 0) {
            return AxisAlignedBB.func_72330_a((double)coords.x, (double)(coords.y - offset), (double)(coords.z - offset), (double)(coords.x + offset), (double)(coords.y + offset), (double)(coords.z + offset));
        }
        if (direction.offsetY > 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)(coords.y - offset), (double)(coords.z - offset), (double)(coords.x + offset), (double)coords.y, (double)(coords.z + offset));
        }
        if (direction.offsetY < 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)coords.y, (double)(coords.z - offset), (double)(coords.x + offset), (double)(coords.y + offset), (double)(coords.z + offset));
        }
        if (direction.offsetZ > 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)(coords.y - offset), (double)(coords.z - offset), (double)(coords.x + offset), (double)(coords.y + offset), (double)coords.z);
        }
        if (direction.offsetZ < 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)(coords.y - offset), (double)coords.z, (double)(coords.x + offset), (double)(coords.y + offset), (double)(coords.z + offset));
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public static AxisAlignedBB getDeepBox(Coordinates coords, ForgeDirection direction, int depth) {
        if (direction.offsetX != 0) {
            if (direction.offsetX > 0) {
                return AxisAlignedBB.func_72330_a((double)(coords.x - depth), (double)(coords.y - 1), (double)(coords.z - 1), (double)coords.x, (double)(coords.y + 1), (double)(coords.z + 1));
            }
            return AxisAlignedBB.func_72330_a((double)coords.x, (double)(coords.y - 1), (double)(coords.z - 1), (double)(coords.x + depth), (double)(coords.y + 1), (double)(coords.z + 1));
        }
        if (direction.offsetY != 0) {
            if (direction.offsetY > 0) {
                return AxisAlignedBB.func_72330_a((double)(coords.x - 1), (double)(coords.y - depth), (double)(coords.z - 1), (double)(coords.x + 1), (double)coords.y, (double)(coords.z + 1));
            }
            return AxisAlignedBB.func_72330_a((double)(coords.x - 1), (double)coords.y, (double)(coords.z - 1), (double)(coords.x + 1), (double)(coords.y + depth), (double)(coords.z + 1));
        }
        if (direction.offsetZ > 0) {
            return AxisAlignedBB.func_72330_a((double)(coords.x - 1), (double)(coords.y - 1), (double)(coords.z - depth), (double)(coords.x + 1), (double)(coords.y + 1), (double)coords.z);
        }
        return AxisAlignedBB.func_72330_a((double)(coords.x - 1), (double)(coords.y - 1), (double)coords.z, (double)(coords.x + 1), (double)(coords.y + 1), (double)(coords.z + depth));
    }

    public static AxisAlignedBB getFlatYBox(Coordinates coords, int offset) {
        return AxisAlignedBB.func_72330_a((double)(coords.x - offset), (double)coords.y, (double)(coords.z - offset), (double)(coords.x + offset), (double)coords.y, (double)(coords.z + offset));
    }

    public static <T extends Entity> T getNewEntityInstance(Class<T> c, World world) {
        try {
            Constructor<T> constr = c.getConstructor(World.class);
            Entity ent = (Entity)constr.newInstance(world);
            if (ent instanceof EntitySkeleton) {
                if (world.field_73012_v.nextInt(2) == 0) {
                    ((EntitySkeleton)ent).func_82201_a(1);
                    ent.func_70062_b(0, new ItemStack(Items.field_151052_q));
                } else {
                    ent.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
                }
            } else if (ent instanceof EntityPigZombie) {
                ent.func_70062_b(0, new ItemStack(Items.field_151010_B));
            }
            return (T)ent;
        }
        catch (Exception e) {
            PELogger.logFatal("Could not create new entity instance for: " + c.getCanonicalName());
            e.printStackTrace();
            return null;
        }
    }

    public static EntityLiving getRandomEntity(World world, EntityLiving toRandomize) {
        Class<?> entClass = toRandomize.getClass();
        if (peacefuls.contains(entClass)) {
            return (EntityLiving)WorldHelper.getNewEntityInstance(CollectionHelper.getRandomListEntry(peacefuls, entClass), world);
        }
        if (mobs.contains(entClass)) {
            return (EntityLiving)WorldHelper.getNewEntityInstance(CollectionHelper.getRandomListEntry(mobs, entClass), world);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            return new EntitySlime(world);
        }
        return new EntitySheep(world);
    }

    public static List<TileEntity> getTileEntitiesWithinAABB(World world, AxisAlignedBB bBox) {
        ArrayList list = Lists.newArrayList();
        int i = (int)bBox.field_72340_a;
        while ((double)i <= bBox.field_72336_d) {
            int j = (int)bBox.field_72338_b;
            while ((double)j <= bBox.field_72337_e) {
                int k = (int)bBox.field_72339_c;
                while ((double)k <= bBox.field_72334_f) {
                    TileEntity tile = world.func_147438_o(i, j, k);
                    if (tile != null) {
                        list.add(tile);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static void gravitateEntityTowards(Entity ent, double x, double y, double z) {
        double dX = x - ent.field_70165_t;
        double dY = y - ent.field_70163_u;
        double dZ = z - ent.field_70161_v;
        double dist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.field_70159_w += dX / dist * vel * 0.05;
            ent.field_70181_x += dY / dist * vel * 0.1;
            ent.field_70179_y += dZ / dist * vel * 0.05;
            ent.func_70091_d(ent.field_70159_w, ent.field_70181_x, ent.field_70179_y);
        }
    }

    public static void growNearbyRandomly(boolean harvest, World world, double xCoord, double yCoord, double zCoord, EntityPlayer player) {
        int chance = harvest ? 16 : 32;
        int x = (int)(xCoord - 5.0);
        while ((double)x <= xCoord + 5.0) {
            int y = (int)(yCoord - 3.0);
            while ((double)y <= yCoord + 3.0) {
                int z = (int)(zCoord - 5.0);
                while ((double)z <= zCoord + 5.0) {
                    Block crop = world.func_147439_a(x, y, z);
                    if (crop instanceof IShearable) {
                        if (harvest) {
                            if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                                world.func_147480_a(x, y, z, true);
                            } else if (player == null) {
                                world.func_147480_a(x, y, z, true);
                            }
                        }
                    } else if (crop instanceof IGrowable) {
                        IGrowable growable = (IGrowable)crop;
                        if (harvest && !growable.func_149851_a(world, x, y, z, false)) {
                            if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                                world.func_147480_a(x, y, z, true);
                            } else if (player == null) {
                                world.func_147480_a(x, y, z, true);
                            }
                        } else if (world.field_73012_v.nextInt(chance) == 0 && (ProjectEConfig.harvBandGrass || !crop.func_149739_a().toLowerCase(Locale.ROOT).contains("grass"))) {
                            growable.func_149853_b(world, world.field_73012_v, x, y, z);
                        }
                    } else if (crop instanceof IPlantable) {
                        if (world.field_73012_v.nextInt(chance / 4) == 0) {
                            for (int i = 0; i < (harvest ? 8 : 4); ++i) {
                                crop.func_149674_a(world, x, y, z, world.field_73012_v);
                            }
                        }
                        if (harvest) {
                            int meta;
                            if (crop instanceof BlockFlower) {
                                if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                                    world.func_147480_a(x, y, z, true);
                                } else if (player == null) {
                                    world.func_147480_a(x, y, z, true);
                                }
                            }
                            if (crop == Blocks.field_150436_aH || crop == Blocks.field_150434_aF) {
                                int i;
                                boolean shouldHarvest = true;
                                for (i = 1; i < 3; ++i) {
                                    if (world.func_147439_a(x, y + i, z) == crop) continue;
                                    shouldHarvest = false;
                                    break;
                                }
                                if (shouldHarvest) {
                                    int n = i = crop == Blocks.field_150436_aH ? 1 : 0;
                                    while (i < 3) {
                                        if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y + i, z)) {
                                            world.func_147480_a(x, y + i, z, true);
                                        } else if (player == null) {
                                            world.func_147480_a(x, y + i, z, true);
                                        }
                                        ++i;
                                    }
                                }
                            }
                            if (crop == Blocks.field_150388_bm && (meta = ((IPlantable)crop).getPlantMetadata((IBlockAccess)world, x, y, z)) == 3) {
                                if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                                    world.func_147480_a(x, y, z, true);
                                } else if (player == null) {
                                    world.func_147480_a(x, y, z, true);
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void harvestVein(World world, EntityPlayer player, ItemStack stack, Coordinates coords, Block target, List<ItemStack> currentDrops, int numMined) {
        if (numMined >= 250) {
            return;
        }
        AxisAlignedBB b = AxisAlignedBB.func_72330_a((double)(coords.x - 1), (double)(coords.y - 1), (double)(coords.z - 1), (double)(coords.x + 1), (double)(coords.y + 1), (double)(coords.z + 1));
        int x = (int)b.field_72340_a;
        while ((double)x <= b.field_72336_d) {
            int y = (int)b.field_72338_b;
            while ((double)y <= b.field_72337_e) {
                int z = (int)b.field_72339_c;
                while ((double)z <= b.field_72334_f) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == target || target == Blocks.field_150439_ay && block == Blocks.field_150450_ax) {
                        ++numMined;
                        if (PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                            currentDrops.addAll(WorldHelper.getBlockDrops(world, player, block, stack, x, y, z));
                            world.func_147468_f(x, y, z);
                            WorldHelper.harvestVein(world, player, stack, new Coordinates(x, y, z), target, currentDrops, numMined);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void igniteNearby(World world, EntityPlayer player) {
        int x = (int)(player.field_70165_t - 8.0);
        while ((double)x <= player.field_70165_t + 8.0) {
            int y = (int)(player.field_70163_u - 5.0);
            while ((double)y <= player.field_70163_u + 5.0) {
                int z = (int)(player.field_70161_v - 8.0);
                while ((double)z <= player.field_70161_v + 8.0) {
                    if (world.field_73012_v.nextInt(128) == 0 && world.func_147437_c(x, y, z)) {
                        PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, x, y, z, (Block)Blocks.field_150480_ab, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static boolean isArrowInGround(EntityArrow arrow) {
        return ReflectionHelper.getArrowInGround(arrow);
    }

    public static void repelEntitiesInAABBFromPoint(World world, AxisAlignedBB effectBounds, double x, double y, double z, boolean isSWRG) {
        List list = world.func_72872_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if ((!isSWRG || swrgBlacklist.contains(ent.getClass())) && (isSWRG || interdictionBlacklist.contains(ent.getClass())) || !(ent instanceof EntityLiving) && !(ent instanceof IProjectile) || !isSWRG && ProjectEConfig.interdictionMode && !(ent instanceof IMob) && !(ent instanceof IProjectile) || ent instanceof EntityArrow && ((EntityArrow)ent).field_70122_E) continue;
            Vec3 p = Vec3.func_72443_a((double)x, (double)y, (double)z);
            Vec3 t = Vec3.func_72443_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v);
            double distance = p.func_72438_d(t) + 0.1;
            Vec3 r = Vec3.func_72443_a((double)(t.field_72450_a - p.field_72450_a), (double)(t.field_72448_b - p.field_72448_b), (double)(t.field_72449_c - p.field_72449_c));
            ent.field_70159_w += r.field_72450_a / 1.5 / distance;
            ent.field_70181_x += r.field_72448_b / 1.5 / distance;
            ent.field_70179_y += r.field_72449_c / 1.5 / distance;
        }
    }

    public static void spawnEntityItem(World world, ItemStack stack, double x, double y, double z) {
        float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int j1 = world.field_73012_v.nextInt(21) + 10;
            if (j1 > stack.field_77994_a) {
                j1 = stack.field_77994_a;
            }
            stack.field_77994_a -= j1;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(stack.func_77973_b(), j1, stack.func_77960_j()));
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
    }
}

