/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.apiculture.EnumBeeType;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.worldgen.ComponentVillageBeeHouse;
import forestry.core.utils.Log;
import forestry.plugins.PluginApiculture;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageHandlerApiculture
implements VillagerRegistry.IVillageCreationHandler,
VillagerRegistry.IVillageTradeHandler {
    public static void registerVillageComponents() {
        try {
            MapGenStructureIO.func_143031_a(ComponentVillageBeeHouse.class, (String)"Forestry:BeeHouse");
        }
        catch (Throwable e) {
            Log.severe("Failed to register village beehouse.");
        }
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        ItemStack wildcardPrincess = new ItemStack((Item)PluginApiculture.items.beePrincessGE, 1, Short.MAX_VALUE);
        ItemStack wildcardDrone = new ItemStack((Item)PluginApiculture.items.beeDroneGE, 4, Short.MAX_VALUE);
        recipeList.add((Object)new MerchantRecipe(wildcardPrincess, new ItemStack(Items.field_151166_bC, 1)));
        ItemStack randomComb = PluginApiculture.items.beeComb.getRandomComb(1, random, false);
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151015_O, 2), randomComb));
        ItemStack apiary = PluginApiculture.blocks.apiculture.get(BlockApicultureType.APIARY);
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150364_r, 24, Short.MAX_VALUE), apiary));
        ItemStack provenFrames = PluginApiculture.items.frameProven.getItemStack(6);
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), provenFrames));
        ItemStack monasticDrone = BeeDefinition.MONASTIC.getMemberStack(EnumBeeType.DRONE);
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 12), wildcardPrincess, monasticDrone));
        ItemStack endDrone = BeeDefinition.ENDED.getMemberStack(EnumBeeType.DRONE);
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151061_bv, 16), wildcardPrincess, endDrone));
        ItemStack propolis = new ItemStack((Item)PluginApiculture.items.propolis, 1);
        ItemStack forestDrone = BeeDefinition.FOREST.getMemberStack(EnumBeeType.DRONE);
        ItemStack meadowsDrone = BeeDefinition.MEADOWS.getMemberStack(EnumBeeType.DRONE);
        ItemStack modestDrone = BeeDefinition.MODEST.getMemberStack(EnumBeeType.DRONE);
        ItemStack tropicalDrone = BeeDefinition.TROPICAL.getMemberStack(EnumBeeType.DRONE);
        ItemStack wintryDrone = BeeDefinition.WINTRY.getMemberStack(EnumBeeType.DRONE);
        ItemStack marshyDrone = BeeDefinition.MARSHY.getMemberStack(EnumBeeType.DRONE);
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, forestDrone));
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, meadowsDrone));
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, modestDrone));
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, tropicalDrone));
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, wintryDrone));
        recipeList.add((Object)new MerchantRecipe(propolis, wildcardDrone, marshyDrone));
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
        return new StructureVillagePieces.PieceWeight(ComponentVillageBeeHouse.class, 15, MathHelper.func_76136_a((Random)random, (int)size, (int)(1 + size)));
    }

    public Class<?> getComponentClass() {
        return ComponentVillageBeeHouse.class;
    }

    public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return ComponentVillageBeeHouse.buildComponent(startPiece, pieces, random, p1, p2, p3, p4, p5);
    }
}

