/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumErrorCode implements IErrorState
{
    UNKNOWN("unknown"),
    WRONGSTACKSIZE("wrongStacksize"),
    NODISPOSAL("noDisposal"),
    INVALIDBIOME("invalidBiome"),
    TOO_HOT("tooHot"),
    TOO_COLD("tooCold"),
    TOO_HUMID("tooHumid"),
    TOO_ARID("tooArid", "invalidBiome"),
    IS_RAINING("isRaining"),
    NOT_GLOOMY("notGloomy"),
    NOT_BRIGHT("notLucid"),
    NOT_DAY("notDay"),
    NOT_NIGHT("notNight"),
    NO_FLOWER("noFlower"),
    NO_QUEEN("noQueen"),
    NO_DRONE("noDrone"),
    NO_SKY("noSky"),
    NO_RESOURCE("noResource"),
    NO_RESOURCE_INVENTORY("noResourceInventory", "noResource"),
    NO_RESOURCE_LIQUID("noResourceLiquid", "noLiquid"),
    NO_RECIPE("noRecipe"),
    NO_SPACE_INVENTORY("noSpace"),
    NO_SPACE_TANK("noSpaceTank", "noLiquid"),
    NO_POWER("noPower"),
    NO_REDSTONE("noRedstone", "disabled"),
    DISABLED_BY_REDSTONE("disabledRedstone", "disabled"),
    NOT_DARK("notDark", "notGloomy"),
    NOT_RAINING("notRaining"),
    NO_RAIN_BIOME("noRainBiome", "notRaining"),
    NO_SKY_RAIN_TANK("noSkyRainTank", "noSky"),
    NO_HONEY("noHoney"),
    NO_SPECIMEN("noSpecimen"),
    FORCED_COOLDOWN("forcedCooldown"),
    NO_FUEL("noFuel"),
    NO_HEAT("noHeat"),
    NO_ENERGY_NET("noEnergyNet"),
    NO_STAMPS("noStamps"),
    NO_PAPER("noPaper"),
    NO_SUPPLIES("noSupplies", "noResource"),
    NO_TRADE("noTrade", "noResource"),
    NOT_ALPHANUMERIC("notAlphaNumeric"),
    NOT_UNIQUE("notUnique"),
    NOT_POST_PAID("notPostpaid", "noStamps"),
    NO_RECIPIENT("noRecipient"),
    NO_CIRCUIT_BOARD("noCircuitBoard"),
    NO_CIRCUIT_LAYOUT("noCircuitLayout"),
    CIRCUIT_MISMATCH("circuitMismatch"),
    NO_FERTILIZER("noFertilizer"),
    NO_FARMLAND("noFarmland"),
    NO_LIQUID_FARM("noLiquid");

    private final String name;
    private final String iconName;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    private EnumErrorCode(String name) {
        this(name, name);
    }

    private EnumErrorCode(String name, String iconName) {
        this.name = name;
        this.iconName = iconName;
    }

    @Override
    public String getDescription() {
        return "errors." + this.name + ".desc";
    }

    @Override
    public String getHelp() {
        return "errors." + this.name + ".help";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("forestry:errors/" + this.iconName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public short getID() {
        return (short)this.ordinal();
    }

    @Override
    public String getUniqueName() {
        return "Forestry:" + this.name;
    }

    public static void init() {
        for (EnumErrorCode code : EnumErrorCode.values()) {
            ForestryAPI.errorStateRegistry.registerErrorState(code);
        }
    }
}

