/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogic;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.GuiHandler;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import forestry.mail.MailAddress;
import forestry.mail.TradeStation;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.gui.ContainerTrader;
import forestry.mail.gui.GuiTradeName;
import forestry.mail.gui.GuiTrader;
import forestry.mail.inventory.InventoryTradeStation;
import forestry.mail.network.packets.PacketTraderAddressResponse;
import forestry.mail.triggers.MailTriggers;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTrader
extends TileBase {
    private IMailAddress address = new MailAddress();

    public TileTrader() {
        super("trade.station");
        this.setInternalInventory(new InventoryTradeStation());
    }

    @Override
    public void openGui(EntityPlayer player) {
        short data = (short)(!this.isLinked() ? 1 : 0);
        GuiHandler.openGui(player, this, data);
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostManager.postRegistry.deleteTradeStation(this.field_145850_b, this.address);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.address != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.func_74782_a("address", (NBTBase)nbt);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.func_74775_l("address"));
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        String name = null;
        if (this.address != null) {
            name = this.address.getName();
        }
        if (name == null) {
            name = "";
        }
        data.writeUTF(name);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        String address = data.readUTF();
        if (address.length() > 0) {
            this.address = PostManager.postRegistry.getMailAddress(address);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked() || !this.updateOnInterval(10)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.hasPostageMin(3), EnumErrorCode.NO_STAMPS);
        errorLogic.setCondition(!this.hasPaperMin(2), EnumErrorCode.NO_PAPER);
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.func_70301_a(0);
        errorLogic.setCondition(tradeGood == null, EnumErrorCode.NO_TRADE);
        boolean hasRequest = this.hasItemCount(1, 4, null, 1);
        errorLogic.setCondition(!hasRequest, EnumErrorCode.NO_TRADE);
        if (tradeGood != null) {
            boolean hasSupplies = this.hasItemCount(30, 10, tradeGood, tradeGood.field_77994_a);
            errorLogic.setCondition(!hasSupplies, EnumErrorCode.NO_SUPPLIES);
        }
        if (inventory instanceof TradeStation && this.updateOnInterval(200)) {
            boolean canReceivePayment = ((TradeStation)inventory).canReceivePayment();
            errorLogic.setCondition(!canReceivePayment, EnumErrorCode.NO_SPACE_INVENTORY);
        }
    }

    public boolean isLinked() {
        if (this.address == null || !this.address.isValid()) {
            return false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        return !errorLogic.contains(EnumErrorCode.NOT_ALPHANUMERIC) && !errorLogic.contains(EnumErrorCode.NOT_UNIQUE);
    }

    private boolean hasItemCount(int startSlot, int countSlots, ItemStack item, int itemCount) {
        int count = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot == null) continue;
            if (item == null || ItemStackUtil.isIdenticalItem(itemInSlot, item)) {
                count += itemInSlot.field_77994_a;
            }
            if (count < itemCount) continue;
            return true;
        }
        return false;
    }

    private float percentOccupied(int startSlot, int countSlots, ItemStack item) {
        int count = 0;
        int total = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.func_70301_a(i);
            if (itemInSlot == null) {
                total += 64;
                continue;
            }
            total += itemInSlot.func_77976_d();
            if (item != null && !ItemStackUtil.isIdenticalItem(itemInSlot, item)) continue;
            count += itemInSlot.field_77994_a;
        }
        return (float)count / (float)total;
    }

    public boolean hasPaperMin(int count) {
        return this.hasItemCount(5, 6, new ItemStack(Items.field_151121_aF), count);
    }

    public boolean hasInputBufMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.func_70301_a(0);
        if (tradeGood == null) {
            return true;
        }
        return this.percentOccupied(30, 10, tradeGood) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(15, 15, null) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.func_70301_a(i);
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || (posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a) < postage) continue;
            return true;
        }
        return false;
    }

    public IMailAddress getAddress() {
        return this.address;
    }

    public void handleSetAddressRequest(String addressName) {
        String newAddressName;
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
        IMailAddress newAddress = this.getAddress();
        if (newAddress != null && (newAddressName = newAddress.getName()) != null && newAddressName.equals(addressName)) {
            PacketTraderAddressResponse packetResponse = new PacketTraderAddressResponse(this, addressName);
            Proxies.net.sendNetworkPacket(packetResponse, this.field_145850_b);
        }
    }

    public void handleSetAddressResponse(String addressName) {
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
    }

    private void setAddress(IMailAddress address) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (this.address != null && this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            IErrorLogic errorLogic = this.getErrorLogic();
            boolean hasValidTradeAddress = PostManager.postRegistry.isValidTradeAddress(this.field_145850_b, address);
            errorLogic.setCondition(!hasValidTradeAddress, EnumErrorCode.NOT_ALPHANUMERIC);
            boolean hasUniqueTradeAddress = PostManager.postRegistry.isAvailableTradeAddress(this.field_145850_b, address);
            errorLogic.setCondition(!hasUniqueTradeAddress, EnumErrorCode.NOT_UNIQUE);
            if (hasValidTradeAddress & hasUniqueTradeAddress) {
                this.address = address;
                PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getAccessHandler().getOwner(), address);
            }
        } else {
            this.address = address;
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.field_145850_b.field_72995_K || !this.address.isValid()) {
            return super.getInternalInventory();
        }
        return (TradeStation)PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getAccessHandler().getOwner(), this.address);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(MailTriggers.lowPaper64);
        res.add(MailTriggers.lowPaper32);
        res.add(MailTriggers.lowInput25);
        res.add(MailTriggers.lowInput10);
        res.add(MailTriggers.lowPostage40);
        res.add(MailTriggers.lowPostage20);
        res.add(MailTriggers.highBuffer90);
        res.add(MailTriggers.highBuffer75);
        return res;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        if (data == 0) {
            return new GuiTrader(player.field_71071_by, this);
        }
        return new GuiTradeName(this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        if (data == 0) {
            return new ContainerTrader(player.field_71071_by, this);
        }
        return new ContainerTradeName(this);
    }
}

