/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import ivorius.pandorasbox.block.PBBlocks;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;

public class PandorasBoxHelper {
    public static List<WeightedEntity> mobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> creatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> tameableCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedRandomChestContent> blocksAndItems = new ArrayList<WeightedRandomChestContent>();
    public static Hashtable<Block, int[]> randomBlockMetadatas = new Hashtable();
    private static Hashtable<Block, Integer> cachedBlockHashes = new Hashtable();
    public static List<WeightedBlock> blocks = new ArrayList<WeightedBlock>();
    public static List<WeightedRandomChestContent> items = new ArrayList<WeightedRandomChestContent>();
    public static List<WeightedSet> equipmentSets = new ArrayList<WeightedSet>();
    public static Hashtable<Item, Hashtable<Integer, ItemStack>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();
    public static List<WeightedRandomChestContent> enchantableArmorList = new ArrayList<WeightedRandomChestContent>();
    public static List<WeightedRandomChestContent> enchantableToolList = new ArrayList<WeightedRandomChestContent>();
    public static List<WeightedBlock> heavyBlocks = new ArrayList<WeightedBlock>();

    public static void addEntities(List<WeightedEntity> list, int weight, int minNumber, int maxNumber, String ... entities) {
        for (String s : entities) {
            list.add(new WeightedEntity(weight, s, minNumber, maxNumber));
        }
    }

    public static void addBlocks(int weight, Block ... blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = Item.func_150898_a((Block)block);
            PandorasBoxHelper.addItem(new WeightedRandomChestContent(item, 0, 1, item.getItemStackLimit(new ItemStack(item)), weight));
        }
    }

    public static void addBlocks(List<WeightedBlock> list, int weight, Block ... blocks) {
        for (Block block : blocks) {
            list.add(new WeightedBlock(weight, block));
        }
    }

    public static void addItem(WeightedRandomChestContent weightedRandomChestContent) {
        items.add(weightedRandomChestContent);
        blocksAndItems.add(weightedRandomChestContent);
    }

    public static void addItems(int weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new WeightedRandomChestContent(item, 0, 1, item.getItemStackLimit(new ItemStack(item)), weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new WeightedRandomChestContent(itemStack, 1, itemStack.func_77973_b().getItemStackLimit(itemStack), weight));
        }
    }

    public static void addItemsMinMax(int weight, int min, int max, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new WeightedRandomChestContent(item, 0, min, max, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new WeightedRandomChestContent(itemStack, min, max, weight));
        }
    }

    public static void addEquipmentSet(int weight, Object ... items) {
        ItemStack[] set = new ItemStack[items.length];
        for (int i = 0; i < set.length; ++i) {
            ItemStack itemStack;
            if (items[i] instanceof Item) {
                Item item = (Item)items[i];
                set[i] = new ItemStack(item);
                continue;
            }
            if (!(items[i] instanceof ItemStack)) continue;
            set[i] = itemStack = (ItemStack)items[i];
        }
        equipmentSets.add(new WeightedSet(weight, set));
    }

    public static void addPotions(List<WeightedPotion> list, int weight, int minStrength, int maxStrength, int minDuration, int maxDuration, Potion ... potions) {
        for (Potion potion : potions) {
            list.add(new WeightedPotion(weight, potion, minStrength, maxStrength, minDuration, maxDuration));
        }
    }

    public static void addEnchantableArmor(int weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableArmorList.add(new WeightedRandomChestContent(item, 0, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableArmorList.add(new WeightedRandomChestContent(itemStack, 1, 1, weight));
        }
    }

    public static void addEnchantableTools(int weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableToolList.add(new WeightedRandomChestContent(item, 0, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableToolList.add(new WeightedRandomChestContent(itemStack, 1, 1, weight));
        }
    }

    public static void addEquipmentForLevel(Item base, int level, ItemStack stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(Item base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof Item) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new ItemStack((Item)items[i]));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (ItemStack)items[i]);
        }
    }

    public static void addBlockMetadatas(int[] metas, Block ... blocks) {
        for (Block block : blocks) {
            randomBlockMetadatas.put(block, metas);
        }
    }

    public static void addBlockMetadatas(int maxMetadata, Block ... blocks) {
        int[] array = new int[maxMetadata + 1];
        for (int i = 0; i <= maxMetadata; ++i) {
            array[i] = i;
        }
        PandorasBoxHelper.addBlockMetadatas(array, blocks);
    }

    public static void initialize() {
        PandorasBoxHelper.addEntities(mobs, 100, 3, 10, "Zombie");
        PandorasBoxHelper.addEntities(mobs, 100, 2, 8, "Spider");
        PandorasBoxHelper.addEntities(mobs, 100, 2, 5, "Skeleton");
        PandorasBoxHelper.addEntities(mobs, 100, 2, 8, "Creeper");
        PandorasBoxHelper.addEntities(mobs, 60, 2, 8, "Slime");
        PandorasBoxHelper.addEntities(mobs, 40, 1, 4, "Ghast");
        PandorasBoxHelper.addEntities(mobs, 60, 2, 6, "Enderman");
        PandorasBoxHelper.addEntities(mobs, 60, 2, 8, "PigZombie");
        PandorasBoxHelper.addEntities(mobs, 50, 2, 5, "pbspecial_skeletonWither");
        PandorasBoxHelper.addEntities(mobs, 50, 2, 4, "CaveSpider");
        PandorasBoxHelper.addEntities(mobs, 50, 10, 20, "Silverfish");
        PandorasBoxHelper.addEntities(mobs, 50, 2, 6, "LavaSlime");
        PandorasBoxHelper.addEntities(mobs, 50, 2, 6, "pbspecial_angryWolf");
        PandorasBoxHelper.addEntities(mobs, 40, 2, 5, "Blaze");
        PandorasBoxHelper.addEntities(mobs, 40, 2, 4, "Witch");
        PandorasBoxHelper.addEntities(mobs, 40, 2, 5, "pbspecial_superchargedCreeper");
        PandorasBoxHelper.addEntities(mobs, 10, 1, 1, "WitherBoss");
        PandorasBoxHelper.addEntities(creatures, 100, 3, 10, "Pig", "Sheep", "Cow", "Chicken");
        PandorasBoxHelper.addEntities(creatures, 60, 2, 6, "Wolf");
        PandorasBoxHelper.addEntities(creatures, 50, 4, 10, "Bat");
        PandorasBoxHelper.addEntities(creatures, 40, 3, 7, "MushroomCow");
        PandorasBoxHelper.addEntities(creatures, 40, 3, 7, "SnowMan");
        PandorasBoxHelper.addEntities(creatures, 40, 2, 5, "EntityHorse");
        PandorasBoxHelper.addEntities(creatures, 40, 2, 6, "Ozelot");
        PandorasBoxHelper.addEntities(creatures, 30, 3, 6, "Villager");
        PandorasBoxHelper.addEntities(creatures, 30, 2, 4, "VillagerGolem");
        PandorasBoxHelper.addEntities(waterCreatures, 60, 3, 10, "Squid");
        PandorasBoxHelper.addEntities(tameableCreatures, 40, 1, 4, "pbspecial_wolfTamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 40, 1, 4, "pbspecial_ocelotTamed");
        PandorasBoxHelper.addBlocks(100, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150344_f, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150423_aK, Blocks.field_150325_L, Blocks.field_150435_aG, Blocks.field_150391_bh, Blocks.field_150334_T, Blocks.field_150373_bw});
        PandorasBoxHelper.addBlocks(100, Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150322_A, Blocks.field_150336_V, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150385_bj, Blocks.field_150417_aV, Blocks.field_150377_bs, Blocks.field_150405_ch, Blocks.field_150406_ce);
        PandorasBoxHelper.addBlocks(80, new Block[]{Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150450_ax, Blocks.field_150449_bY, Blocks.field_150359_w, Blocks.field_150399_cn, Blocks.field_150425_aM});
        PandorasBoxHelper.addBlocks(2, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150340_R);
        PandorasBoxHelper.addBlocks(3, Blocks.field_150339_S);
        PandorasBoxHelper.addBlocks(5, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o);
        PandorasBoxHelper.addBlocks(10, Blocks.field_150366_p);
        PandorasBoxHelper.addBlocks(20, Blocks.field_150335_W, Blocks.field_150343_Z, Blocks.field_150426_aN, Blocks.field_150402_ci, Blocks.field_150368_y, Blocks.field_150451_bX);
        PandorasBoxHelper.addBlocks(50, Blocks.field_150418_aU, Blocks.field_150379_bu, Blocks.field_150371_ca, Blocks.field_150433_aE, Blocks.field_150342_X, Blocks.field_150428_aP, Blocks.field_150407_cf, Blocks.field_150440_ba);
        PandorasBoxHelper.addItems(100, Items.field_151044_h, Items.field_151016_H, Items.field_151015_O, Items.field_151141_av, Items.field_151137_ax, Items.field_151103_aS, Items.field_151127_ba, Items.field_151119_aD, Items.field_151122_aG, Items.field_151074_bl, Items.field_151174_bG, Items.field_151133_ar, Items.field_151055_y, Items.field_151007_F, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N, Items.field_151126_ay, Items.field_151102_aT, Items.field_151112_aM, Items.field_151156_bN, Items.field_151075_bm, Items.field_151145_ak, Items.field_151110_aK, Items.field_151118_aC, Items.field_151121_aF, new ItemStack(Blocks.field_150478_aa));
        PandorasBoxHelper.addItems(100, Item.func_150898_a((Block)PBBlocks.pandorasBox));
        PandorasBoxHelper.addItems(100, Items.field_151076_bf, Items.field_151077_bg, Items.field_151082_bd, Items.field_151158_bO, Items.field_151083_be, Items.field_151009_A, Items.field_151078_bh, Items.field_151172_bF, Items.field_151147_al, Items.field_151157_am, Items.field_151034_e, Items.field_151105_aU, Items.field_151025_P, Items.field_151106_aX, Items.field_151115_aP, Items.field_151101_aQ);
        PandorasBoxHelper.addItems(80, Items.field_151129_at, Items.field_151117_aB, Items.field_151131_as, Items.field_151033_d, Items.field_151159_an, Items.field_151162_bE, Items.field_151104_aV, Items.field_151124_az, Items.field_151143_au, Items.field_151066_bu);
        PandorasBoxHelper.addItems(80, Items.field_151057_cb);
        PandorasBoxHelper.addItems(60, Items.field_151042_j, Items.field_151114_aO, Items.field_151065_br, Items.field_151072_bj, Items.field_151113_aN, Items.field_151073_bk, Items.field_151061_bv, Items.field_151060_bw, Items.field_151070_bp, Items.field_151071_bq, Items.field_151064_bs, Items.field_151150_bK);
        PandorasBoxHelper.addItems(40, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addItems(40, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addItems(40, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addItems(30, Items.field_151138_bX, Items.field_151136_bY);
        PandorasBoxHelper.addItems(20, Items.field_151125_bZ);
        PandorasBoxHelper.addItemsMinMax(20, 1, 1, new ItemStack((Block)Blocks.field_150461_bJ), new ItemStack(Blocks.field_150467_bQ), new ItemStack(Blocks.field_150382_bo), new ItemStack(Blocks.field_150367_z), new ItemStack(Blocks.field_150477_bB), new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150381_bn));
        PandorasBoxHelper.addItemsMinMax(50, 1, 1, new ItemStack((Block)Blocks.field_150486_ae));
        PandorasBoxHelper.addItems(20, Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151153_ao, Items.field_151079_bi);
        PandorasBoxHelper.addItems(20, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addItems(20, Items.field_151086_cn, Items.field_151096_cd, Items.field_151094_cf, Items.field_151093_ce, Items.field_151091_cg, Items.field_151092_ch, Items.field_151089_ci, Items.field_151090_cj, Items.field_151087_ck, Items.field_151088_cl, Items.field_151084_co, Items.field_151085_cm);
        for (int i = 0; i < 16; ++i) {
            PandorasBoxHelper.addItems(100, new ItemStack(Items.field_151100_aR, 1, i));
        }
        PandorasBoxHelper.addEquipmentSet(100, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addEquipmentSet(60, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addEquipmentSet(40, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addEquipmentSet(20, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addEquipmentSet(60, Items.field_151031_f, new ItemStack(Items.field_151032_g, 64), Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151036_c, new ItemStack(Items.field_151034_e, 8));
        PandorasBoxHelper.addEquipmentSet(60, Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151046_w, Items.field_151037_a, Items.field_151036_c, Items.field_151052_q, new ItemStack(Items.field_151025_P, 8), new ItemStack(Blocks.field_150478_aa, 32));
        PandorasBoxHelper.addEquipmentSet(80, Items.field_151024_Q, Items.field_151019_K, new ItemStack(Items.field_151014_N, 32), new ItemStack(Items.field_151080_bb, 4), new ItemStack(Items.field_151081_bc, 4), new ItemStack(Items.field_151100_aR, 8, 15), new ItemStack(Blocks.field_150346_d, 32), Items.field_151131_as, Items.field_151131_as);
        PandorasBoxHelper.addEquipmentSet(60, Items.field_151028_Y, Items.field_151056_x, new ItemStack(Items.field_151082_bd, 16));
        PandorasBoxHelper.addEquipmentSet(60, new ItemStack(Items.field_151137_ax, 64), new ItemStack(Blocks.field_150325_L, 16, 0), new ItemStack(Blocks.field_150325_L, 16, 15), new ItemStack(Blocks.field_150325_L, 16, 1), new ItemStack(Blocks.field_150451_bX, 8), new ItemStack(Blocks.field_150429_aA, 8));
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151041_m, Items.field_151041_m, Items.field_151010_B, Items.field_151052_q, Items.field_151040_l, Items.field_151048_u);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151053_p, Items.field_151053_p, Items.field_151006_E, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151039_o, Items.field_151039_o, Items.field_151005_D, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151038_n, Items.field_151038_n, Items.field_151011_C, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151017_I, Items.field_151017_I, Items.field_151013_M, Items.field_151018_J, Items.field_151019_K, Items.field_151012_L);
        PandorasBoxHelper.addPotions(buffs, 100, 0, 3, 1200, 12000, Potion.field_76428_l, Potion.field_76424_c, Potion.field_76420_g, Potion.field_76430_j, Potion.field_76429_m, Potion.field_76427_o, Potion.field_76426_n, Potion.field_76439_r, Potion.field_76441_p, Potion.field_76444_x);
        PandorasBoxHelper.addPotions(debuffs, 100, 0, 3, 1200, 12000, Potion.field_76440_q, Potion.field_76431_k, Potion.field_76419_f, Potion.field_76437_t, Potion.field_76438_s);
        PandorasBoxHelper.addPotions(debuffs, 100, 0, 2, 600, 1200, Potion.field_82731_v);
        PandorasBoxHelper.addEnchantableArmor(100, Items.field_151028_Y, Items.field_151169_ag, Items.field_151161_ac, Items.field_151030_Z, Items.field_151171_ah, Items.field_151163_ad, Items.field_151165_aa, Items.field_151149_ai, Items.field_151173_ae, Items.field_151167_ab, Items.field_151151_aj, Items.field_151175_af);
        PandorasBoxHelper.addEnchantableTools(100, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x, Items.field_151031_f);
        PandorasBoxHelper.addBlocks(heavyBlocks, 100, Blocks.field_150467_bQ);
        PandorasBoxHelper.addBlockMetadatas(15, new Block[]{Blocks.field_150325_L, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150406_ce});
        PandorasBoxHelper.addBlockMetadatas(7, new Block[]{Blocks.field_150334_T, Blocks.field_150373_bw});
        PandorasBoxHelper.addBlockMetadatas(5, Blocks.field_150344_f);
        PandorasBoxHelper.addBlockMetadatas(3, new Block[]{Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150417_aV});
        PandorasBoxHelper.addBlockMetadatas(2, Blocks.field_150371_ca, Blocks.field_150322_A);
        PandorasBoxHelper.addBlockMetadatas(1, new Block[]{Blocks.field_150354_m});
    }

    public static int getRandomUnifiedSeed(Random random) {
        return Math.abs(random.nextInt());
    }

    public static int getRandomBlockMetadata(Random rand, Block block, int unified) {
        if (randomBlockMetadatas.containsKey(block)) {
            int[] metas = randomBlockMetadatas.get(block);
            if (unified < 0) {
                return metas[rand.nextInt(metas.length)];
            }
            if (!cachedBlockHashes.containsKey(block)) {
                cachedBlockHashes.put(block, Math.abs(Block.field_149771_c.func_148750_c((Object)block).hashCode()));
            }
            int blockIDHash = cachedBlockHashes.get(block);
            return metas[(unified ^ blockIDHash) % metas.length];
        }
        return 0;
    }

    public static Block[] getRandomBlockList(Random rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.nextFloat() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.nextFloat() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        Block[] blocks = new Block[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            Block block = ((WeightedBlock)WeightedRandom.func_76271_a((Random)rand, selection)).block;
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static Block getRandomBlock(Random rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && randomBlockList.size() > 0) {
            return ((WeightedBlock)WeightedRandom.func_76271_a((Random)rand, randomBlockList)).block;
        }
        return ((WeightedBlock)WeightedRandom.func_76271_a((Random)rand, PandorasBoxHelper.blocks)).block;
    }

    public static WeightedEntity[] getRandomEntityList(Random rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.nextInt(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(Random rand, Collection<WeightedEntity> entityList) {
        return (WeightedEntity)WeightedRandom.func_76271_a((Random)rand, entityList);
    }

    public static ItemStack getRandomWeaponItemForLevel(Random random, int level) {
        Set<Item> itemSet = equipmentForLevels.keySet();
        Item[] itemArray = itemSet.toArray(new Item[itemSet.size()]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.nextInt(itemArray.length)], level);
    }

    public static ItemStack getWeaponItemForLevel(Item baseItem, int level) {
        Hashtable<Integer, ItemStack> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

