/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PBEffectEntitiesThrowItems
extends PBEffectEntityBased {
    public double chancePerItem;
    public double itemDeletionChance;
    public ItemStack[] smuggledInItems;

    public PBEffectEntitiesThrowItems() {
    }

    public PBEffectEntitiesThrowItems(int maxTicksAlive, double range, double chancePerItem, double itemDeletionChance, ItemStack[] smuggledInItems) {
        super(maxTicksAlive, range);
        this.chancePerItem = chancePerItem;
        this.itemDeletionChance = itemDeletionChance;
        this.smuggledInItems = smuggledInItems;
    }

    @Override
    public void affectEntity(World world, EntityPandorasBox box, Random random, EntityLivingBase entity, double newRatio, double prevRatio, double strength) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            double expectedThrow;
            int i;
            EntityPlayer player = (EntityPlayer)entity;
            Random itemRandom = new Random(entity.func_145782_y());
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack;
                expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow) || (stack = player.field_71071_by.func_70301_a(i)) == null || !(random.nextDouble() < this.chancePerItem)) continue;
                if (random.nextDouble() >= this.itemDeletionChance) {
                    this.throwItem((Entity)entity, world, stack);
                }
                player.field_71071_by.func_70299_a(i, null);
            }
            for (i = 0; i < this.smuggledInItems.length; ++i) {
                expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow)) continue;
                this.throwItem((Entity)entity, world, this.smuggledInItems[i]);
            }
        }
    }

    private void throwItem(Entity entity, World world, ItemStack itemStack) {
        EntityItem entityItem = new EntityItem(world, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, itemStack);
        entityItem.field_145804_b = 20;
        entityItem.field_70159_w = (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 1.0;
        entityItem.field_70179_y = (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 1.0;
        entityItem.field_70181_x = world.field_73012_v.nextDouble();
        world.func_72838_d((Entity)entityItem);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("chancePerItem", this.chancePerItem);
        compound.func_74780_a("itemDeletionChance", this.itemDeletionChance);
        PBEffectEntitiesThrowItems.setNBTStacks("smuggledInItems", this.smuggledInItems, compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.chancePerItem = compound.func_74769_h("chancePerItem");
        this.itemDeletionChance = compound.func_74769_h("itemDeletionChance");
        this.smuggledInItems = PBEffectEntitiesThrowItems.getNBTStacks("smuggledInItems", compound);
    }
}

