/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PBEffectGenDome
extends PBEffectGenerate2D {
    public Block block;
    public Block fillBlock;

    public PBEffectGenDome() {
    }

    public PBEffectGenDome(int time, double range, int unifiedSeed, Block block, Block fillBlock) {
        super(time, range, 2, unifiedSeed);
        this.block = block;
        this.fillBlock = fillBlock;
    }

    @Override
    public void generateOnSurface(World world, EntityPandorasBox box, Vec3 effectCenter, Random random, int pass, int x, int baseY, int z, double dist) {
        int domeHeightY = MathHelper.func_76143_f((double)this.range);
        for (int y = -domeHeightY; y <= domeHeightY; ++y) {
            Block block;
            if (pass == 0) {
                if (!PBEffectGenDome.isSpherePart((double)x + 0.5, (double)(baseY + y) + 0.5, (double)z + 0.5, effectCenter.field_72450_a, effectCenter.field_72448_b, effectCenter.field_72449_c, this.range - 1.5, this.range) || !(block = world.func_147439_a(x, baseY + y, z)).isReplaceable((IBlockAccess)world, x, baseY + y, z)) continue;
                PBEffectGenDome.setBlockVarying(world, x, baseY + y, z, this.block, this.unifiedSeed);
                continue;
            }
            if (pass != 1 || this.fillBlock == null || !PBEffectGenDome.isSpherePart((double)x + 0.5, (double)(baseY + y) + 0.5, (double)z + 0.5, effectCenter.field_72450_a, effectCenter.field_72448_b, effectCenter.field_72449_c, 0.0, this.range - 1.5) || !(block = world.func_147439_a(x, baseY + y, z)).isReplaceable((IBlockAccess)world, x, baseY + y, z)) continue;
            PBEffectGenDome.setBlockVarying(world, x, baseY + y, z, this.fillBlock, this.unifiedSeed);
        }
    }

    public static boolean isSpherePart(double x, double y, double z, double centerX, double centerY, double centerZ, double distStart, double distEnd) {
        double xDist = centerX - x;
        double yDist = centerY - y;
        double zDist = centerZ - z;
        double rangeSQ = xDist * xDist + yDist * yDist + zDist * zDist;
        return rangeSQ >= distStart * distStart && rangeSQ < distEnd * distEnd;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
        if (this.fillBlock != null) {
            compound.func_74778_a("fillBlock", Block.field_149771_c.func_148750_c((Object)this.fillBlock));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.block = (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("block"));
        this.fillBlock = (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("fillBlock"));
    }
}

