/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PBEffectGenReplace
extends PBEffectGenerate {
    public Block[] blocks;
    public Block[] blocksToReplace;

    public PBEffectGenReplace() {
    }

    public PBEffectGenReplace(int time, double range, int unifiedSeed, Block[] blocks, Block[] blocksToReplace) {
        super(time, range, 1, unifiedSeed);
        this.blocks = blocks;
        this.blocksToReplace = blocksToReplace;
    }

    @Override
    public void generateOnBlock(World world, EntityPandorasBox entity, Vec3 effectCenter, Random random, int pass, int x, int y, int z, double range) {
        if (!world.field_72995_K) {
            Block newBlock = this.blocks[random.nextInt(this.blocks.length)];
            Block prevBlock = world.func_147439_a(x, y, z);
            boolean replace = false;
            for (Block block : this.blocksToReplace) {
                if (prevBlock != block) continue;
                replace = true;
            }
            if (replace) {
                PBEffectGenReplace.setBlockVarying(world, x, y, z, newBlock, this.unifiedSeed);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        PBEffectGenReplace.setNBTBlocks("blocks", this.blocks, compound);
        PBEffectGenReplace.setNBTBlocks("blocksToReplace", this.blocksToReplace, compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.blocks = PBEffectGenReplace.getNBTBlocks("blocks", compound);
        this.blocksToReplace = PBEffectGenReplace.getNBTBlocks("blocksToReplace", compound);
    }
}

