/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class PBEffectGenerateByFlag
extends PBEffectRangeBased {
    public int unifiedSeed;
    public int[] flags;

    public PBEffectGenerateByFlag() {
    }

    public PBEffectGenerateByFlag(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
        this.flags = new int[961];
    }

    @Override
    public void setUpEffect(World world, EntityPandorasBox entity, Vec3 effectCenter, Random random) {
        super.setUpEffect(world, entity, effectCenter, random);
        byte requiredRange = (byte)MathHelper.func_76143_f((double)this.range);
        int baseX = MathHelper.func_76128_c((double)effectCenter.field_72450_a);
        int baseY = MathHelper.func_76128_c((double)effectCenter.field_72448_b);
        int baseZ = MathHelper.func_76128_c((double)effectCenter.field_72449_c);
        boolean[] flags = new boolean[31];
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                    double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                    if (!(dist <= this.range)) continue;
                    flags[y + 15] = this.hasFlag(world, entity, random, baseX + x, baseY + y, baseZ + z);
                }
                this.setAllFlags(x, z, flags);
            }
        }
    }

    public abstract boolean hasFlag(World var1, EntityPandorasBox var2, Random var3, int var4, int var5, int var6);

    @Override
    public void generateInRange(World world, EntityPandorasBox entity, Random random, Vec3 effectCenter, double prevRange, double newRange, int pass) {
        byte requiredRange = (byte)MathHelper.func_76143_f((double)newRange);
        int baseX = MathHelper.func_76128_c((double)effectCenter.field_72450_a);
        int baseY = MathHelper.func_76128_c((double)effectCenter.field_72448_b);
        int baseZ = MathHelper.func_76128_c((double)effectCenter.field_72449_c);
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                    double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateOnBlock(world, entity, random, pass, x + baseX, y + baseY, z + baseZ, this.getFlag(x, y, z), dist);
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    public abstract void generateOnBlock(World var1, EntityPandorasBox var2, Random var3, int var4, int var5, int var6, int var7, boolean var8, double var9);

    public void setAllFlags(byte x, byte z, boolean ... flags) {
        int flagInt = 0;
        for (int i = flags.length - 1; i >= 0; --i) {
            boolean flag = flags[i];
            if (flag) {
                flagInt = (flagInt << 1) + 1;
                continue;
            }
            flagInt <<= 1;
        }
        this.flags[this.getFlagIndex((byte)x, (byte)z)] = flagInt;
    }

    public void setFlag(byte x, byte y, byte z, boolean flag) {
        int index = this.getFlagIndex(x, z);
        int bit = this.getBitOfFlag(y);
        this.flags[index] = flag ? this.flags[index] | bit : this.flags[index] & ~bit;
    }

    public boolean getFlag(byte x, byte y, byte z) {
        int bit;
        int index = this.getFlagIndex(x, z);
        return (this.flags[index] & (bit = this.getBitOfFlag(y))) > 0;
    }

    public int getBitOfFlag(byte y) {
        return 1 << y + 15;
    }

    public int getFlagIndex(byte x, byte z) {
        return (x + 15) * 31 + (z + 15);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("unifiedSeed", this.unifiedSeed);
        compound.func_74783_a("flags", this.flags);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.func_74762_e("unifiedSeed");
        this.flags = compound.func_74759_k("flags");
    }
}

