/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import ivorius.pandorasbox.math.IvMathHelper;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class PBEffectRangeBased
extends PBEffectNormal {
    public double range;
    public int passes;
    public boolean spreadSquared = true;
    public boolean easeInOut = true;

    public PBEffectRangeBased() {
    }

    public PBEffectRangeBased(int maxTicksAlive, double range, int passes) {
        super(maxTicksAlive);
        this.range = range;
        this.passes = passes;
    }

    @Override
    public void doEffect(World world, EntityPandorasBox entity, Vec3 effectCenter, Random random, float prevRatio, float newRatio) {
        for (int i = 0; i < this.passes; ++i) {
            double prevRange = this.getRange(prevRatio, i);
            double newRange = this.getRange(newRatio, i);
            this.generateInRange(world, entity, random, effectCenter, prevRange, newRange, i);
        }
    }

    private double getRange(double ratio, int pass) {
        if (this.spreadSquared) {
            ratio = Math.sqrt(ratio);
        }
        if (this.easeInOut) {
            ratio = IvMathHelper.mixEaseInOut(0.0, 1.0, ratio);
        }
        double fullRange = this.range + (double)(this.passes - 1) * 5.0;
        double tempRange = ratio * fullRange - (double)pass * 5.0;
        return MathHelper.func_151237_a((double)tempRange, (double)0.0, (double)this.range);
    }

    public abstract void generateInRange(World var1, EntityPandorasBox var2, Random var3, Vec3 var4, double var5, double var7, int var9);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("range", this.range);
        compound.func_74768_a("passes", this.passes);
        compound.func_74757_a("spreadSquared", this.spreadSquared);
        compound.func_74757_a("easeInOut", this.easeInOut);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.range = compound.func_74769_h("range");
        this.passes = compound.func_74762_e("passes");
        this.spreadSquared = compound.func_74767_n("spreadSquared");
        this.easeInOut = compound.func_74767_n("easeInOut");
    }
}

