/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PBEffectRegistry {
    private static Hashtable<String, Class<? extends PBEffect>> registeredEffects = new Hashtable();

    public static Class<? extends PBEffect> getEffect(String id) {
        return registeredEffects.get(id);
    }

    public static void register(Class<? extends PBEffect> effect, String id) {
        registeredEffects.put(id, effect);
    }

    public static Set<String> getAllEffectIDs() {
        return registeredEffects.keySet();
    }

    public static Collection<Class<? extends PBEffect>> getAllEffects() {
        return registeredEffects.values();
    }

    public static void writeEffect(PBEffect effect, NBTTagCompound compound) {
        if (effect != null) {
            compound.func_74778_a("pbEffectID", effect.getEffectID());
            NBTTagCompound pbEffectCompound = new NBTTagCompound();
            effect.writeToNBT(pbEffectCompound);
            compound.func_74782_a("pbEffectCompound", (NBTBase)pbEffectCompound);
        }
    }

    public static PBEffect loadEffect(NBTTagCompound compound) {
        return PBEffectRegistry.loadEffect(compound.func_74779_i("pbEffectID"), compound.func_74775_l("pbEffectCompound"));
    }

    public static PBEffect loadEffect(String id, NBTTagCompound compound) {
        Class<? extends PBEffect> clazz = PBEffectRegistry.getEffect(id);
        PBEffect effect = null;
        if (clazz != null) {
            try {
                effect = clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (effect != null && compound != null) {
            effect.readFromNBT(compound);
            return effect;
        }
        System.err.println("Pandoras Box: Could not load effect with id '" + id + "'!");
        return null;
    }

    public static String getEffectID(PBEffect effect) {
        Class<?> clazz = effect.getClass();
        for (String id : registeredEffects.keySet()) {
            if (!registeredEffects.get(id).equals(clazz)) continue;
            return id;
        }
        return null;
    }
}

