/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import ivorius.pandorasbox.random.PandorasBoxEntityNamer;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PBEffectSpawnEntityIDList
extends PBEffectSpawnEntities {
    public String[][] entityIDs;
    public int nameEntities;
    public int equipLevel;
    public int buffLevel;

    public PBEffectSpawnEntityIDList() {
    }

    public PBEffectSpawnEntityIDList(int time, String[] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = this.get2DStringArray(entityIDs);
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    public PBEffectSpawnEntityIDList(int time, String[][] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = entityIDs;
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    private String[][] get2DStringArray(String[] strings) {
        String[][] result = new String[strings.length][1];
        for (int i = 0; i < strings.length; ++i) {
            result[i][0] = strings[i];
        }
        return result;
    }

    @Override
    public Entity spawnEntity(World world, EntityPandorasBox pbEntity, Random random, int number, double x, double y, double z) {
        String[] entityTower = this.entityIDs[number];
        Entity previousEntity = null;
        for (String entityID : entityTower) {
            Entity newEntity = PBEffectSpawnEntityIDList.createEntity(world, pbEntity, random, entityID, x, y, z);
            if (newEntity instanceof EntityLiving) {
                PBEffectSpawnEntityIDList.randomizeEntity(random, pbEntity.func_145782_y(), (EntityLiving)newEntity, this.nameEntities, this.equipLevel, this.buffLevel);
            }
            if (previousEntity != null) {
                world.func_72838_d(previousEntity);
                previousEntity.func_70078_a(newEntity);
            }
            previousEntity = newEntity;
        }
        if (previousEntity != null) {
            world.func_72838_d(previousEntity);
        }
        return previousEntity;
    }

    public static void randomizeEntity(Random random, long namingSeed, EntityLiving entityLiving, int nameEntities, int equipLevel, int buffLevel) {
        if (nameEntities == 1) {
            entityLiving.func_94058_c(PandorasBoxEntityNamer.getRandomName(random));
            entityLiving.func_94061_f(true);
        } else if (nameEntities == 2) {
            entityLiving.func_94058_c(PandorasBoxEntityNamer.getRandomCasualName(random));
        } else if (nameEntities == 3) {
            entityLiving.func_94058_c(PandorasBoxEntityNamer.getRandomCasualName(new Random(namingSeed)));
        }
        if (equipLevel > 0) {
            float itemChancePerSlot = 1.0f - 0.5f / (float)equipLevel;
            float upgradeChancePerSlot = 1.0f - 1.0f / (float)equipLevel;
            for (int i = 0; i < 5; ++i) {
                int itemLevel;
                if (!(random.nextFloat() < itemChancePerSlot)) continue;
                for (itemLevel = 0; random.nextFloat() < upgradeChancePerSlot && itemLevel < equipLevel; ++itemLevel) {
                }
                if (i == 0) {
                    ItemStack itemStack = PandorasBoxHelper.getRandomWeaponItemForLevel(random, itemLevel);
                    entityLiving.func_70062_b(i, itemStack);
                    continue;
                }
                if (i == 4 && random.nextFloat() < 0.2f / (float)equipLevel) {
                    entityLiving.func_70062_b(4, new ItemStack(random.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                    continue;
                }
                Item item = EntityLiving.func_82161_a((int)i, (int)Math.min(itemLevel, 4));
                if (item != null) {
                    entityLiving.func_70062_b(i, new ItemStack(item));
                    continue;
                }
                System.err.println("Pandora's Box: Item not found for slot '" + i + "', level '" + itemLevel + "'");
            }
        }
        if (buffLevel > 0) {
            IAttributeInstance attackDamage;
            IAttributeInstance movementSpeed;
            IAttributeInstance knockbackResistance;
            IAttributeInstance health = entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (health != null) {
                double healthMultiplierP = random.nextDouble() * (double)buffLevel * 0.25;
                health.func_111121_a(new AttributeModifier("Zeus's magic", healthMultiplierP, 2));
            }
            if ((knockbackResistance = entityLiving.func_110148_a(SharedMonsterAttributes.field_111266_c)) != null) {
                double knockbackResistanceP = random.nextDouble() * (double)buffLevel * 0.25;
                knockbackResistance.func_111121_a(new AttributeModifier("Zeus's magic", knockbackResistanceP, 2));
            }
            if ((movementSpeed = entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null) {
                double movementSpeedP = random.nextDouble() * (double)buffLevel * 0.08;
                movementSpeed.func_111121_a(new AttributeModifier("Zeus's magic", movementSpeedP, 2));
            }
            if ((attackDamage = entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null) {
                double attackDamageP = random.nextDouble() * (double)buffLevel * 0.25;
                attackDamage.func_111121_a(new AttributeModifier("Zeus's magic", attackDamageP, 2));
            }
        }
    }

    public static Entity createEntity(World world, EntityPandorasBox pbEntity, Random random, String entityID, double x, double y, double z) {
        try {
            if ("pbspecial_XP".equals(entityID)) {
                return new EntityXPOrb(world, x, y, z, 10);
            }
            if ("pbspecial_wolfTamed".equals(entityID)) {
                EntityPlayer nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                EntityWolf wolf = new EntityWolf(world);
                wolf.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                if (nearest != null) {
                    wolf.func_70903_f(true);
                    wolf.func_70778_a(null);
                    wolf.func_70624_b(null);
                    wolf.func_152115_b(nearest.func_110124_au().toString());
                    wolf.field_70170_p.func_72960_a((Entity)wolf, (byte)7);
                }
                return wolf;
            }
            if ("pbspecial_ocelotTamed".equals(entityID)) {
                EntityPlayer nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                EntityOcelot ocelot = new EntityOcelot(world);
                ocelot.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                if (nearest != null) {
                    ocelot.func_70903_f(true);
                    ocelot.func_70912_b(1 + ocelot.field_70170_p.field_73012_v.nextInt(3));
                    ocelot.func_152115_b(nearest.func_110124_au().toString());
                    ocelot.field_70170_p.func_72960_a((Entity)ocelot, (byte)7);
                }
                return ocelot;
            }
            if (entityID.startsWith("pbspecial_tnt")) {
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, x, y, z, null);
                entitytntprimed.field_70516_a = Integer.valueOf(entityID.substring(13));
                return entitytntprimed;
            }
            if ("pbspecial_invisibleTnt".startsWith(entityID)) {
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, x, y, z, null);
                entitytntprimed.field_70516_a = Integer.valueOf(entityID.substring(22));
                entitytntprimed.func_82142_c(true);
                return entitytntprimed;
            }
            if ("pbspecial_firework".equals(entityID)) {
                ItemStack stack = new ItemStack(Items.field_151152_bP);
                stack.func_77983_a("Fireworks", (NBTBase)PBEffectSpawnEntityIDList.createRandomFirework(random));
                return new EntityFireworkRocket(world, x, y, z, stack);
            }
            if ("pbspecial_angryWolf".equals(entityID)) {
                EntityWolf wolf = new EntityWolf(world);
                wolf.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                wolf.func_70624_b((EntityLivingBase)world.func_72977_a(x, y, z, 40.0));
                return wolf;
            }
            if ("pbspecial_superchargedCreeper".equals(entityID)) {
                EntityCreeper creeper = new EntityCreeper(world);
                creeper.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                creeper.func_70096_w().func_75692_b(17, (Object)1);
                return creeper;
            }
            if ("pbspecial_skeletonWither".equals(entityID)) {
                EntitySkeleton skeleton = new EntitySkeleton(world);
                skeleton.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                skeleton.func_82201_a(1);
                skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q));
                skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                return skeleton;
            }
            Entity entity = EntityList.func_75620_a((String)entityID, (World)world);
            entity.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
            return entity;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static NBTTagCompound createRandomFirework(Random random) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Explosions", (NBTBase)PBEffectSpawnEntityIDList.createRandomFireworkExplosions(random, random.nextInt(20) != 0 ? 1 : 1 + random.nextInt(2)));
        compound.func_74774_a("Flight", (byte)(random.nextInt(15) != 0 ? 1 : 2 + random.nextInt(2)));
        return compound;
    }

    public static NBTTagList createRandomFireworkExplosions(Random random, int number) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < number; ++i) {
            list.func_74742_a((NBTBase)PBEffectSpawnEntityIDList.createRandomFireworkExplosion(random));
        }
        return list;
    }

    public static NBTTagCompound createRandomFireworkExplosion(Random random) {
        NBTTagCompound fireworkCompound = new NBTTagCompound();
        fireworkCompound.func_74757_a("Flicker", random.nextInt(20) == 0);
        fireworkCompound.func_74757_a("Trail", random.nextInt(30) == 0);
        fireworkCompound.func_74774_a("Type", (byte)(random.nextInt(10) != 0 ? 0 : random.nextInt(4) + 1));
        int[] colors = new int[random.nextInt(15) != 0 ? 1 : random.nextInt(2) + 2];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[random.nextInt(16)];
        }
        fireworkCompound.func_74783_a("Colors", colors);
        if (random.nextInt(25) == 0) {
            int[] fadeColors = new int[random.nextInt(2) + 1];
            for (int i = 0; i < fadeColors.length; ++i) {
                fadeColors[i] = ItemDye.field_150922_c[random.nextInt(16)];
            }
            fireworkCompound.func_74783_a("FadeColors", fadeColors);
        }
        return fireworkCompound;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        PBEffectSpawnEntityIDList.setNBTStrings2D("entityIDs", this.entityIDs, compound);
        compound.func_74768_a("nameEntities", this.nameEntities);
        compound.func_74768_a("equipLevel", this.equipLevel);
        compound.func_74768_a("buffLevel", this.buffLevel);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.entityIDs = PBEffectSpawnEntityIDList.getNBTStrings2D("entityIDs", compound);
        this.nameEntities = compound.func_74762_e("nameEntities");
        this.equipLevel = compound.func_74762_e("equipLevel");
        this.buffLevel = compound.func_74762_e("buffLevel");
    }
}

