/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.mods;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECDrugEntities;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffectEntitiesDrug;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.mods.ModRepresentation;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.ILinear;
import ivorius.pandorasbox.random.IWeighted;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;

public class Psychedelicraft
extends ModRepresentation {
    public static final String MOD_ID = "psychedelicraft";
    public static final List<WeightedDrug> drugs = new ArrayList<WeightedDrug>();

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)MOD_ID);
    }

    public static Item modItem(String id) {
        return Psychedelicraft.item(MOD_ID, id);
    }

    public static Block modBlock(String id) {
        return Psychedelicraft.block(MOD_ID, id);
    }

    public static void addRandomDrugNames(int weight, float minValue, float maxValue, String ... drugNames) {
        for (String drugName : drugNames) {
            drugs.add(new WeightedDrug(weight, drugName, minValue, maxValue));
        }
    }

    public static WeightedDrug getRandomDrug(Random random) {
        return (WeightedDrug)WeightedRandom.func_76271_a((Random)random, drugs);
    }

    public static void initEffectCreators() {
        if (Psychedelicraft.isLoaded()) {
            Psychedelicraft.addRandomDrugNames(100, 0.3f, 1.2f, "Alcohol", "Cannabis", "Cocaine");
            Psychedelicraft.addRandomDrugNames(80, 0.2f, 0.8f, "BrownShrooms", "RedShrooms", "Peyote");
            Psychedelicraft.addRandomDrugNames(50, 0.2f, 1.2f, "Zero");
            PBECRegistry.register((PBEffectCreator)new PBECDrugEntities(new ILinear(60, 600), new IWeighted(1, 100, 2, 80, 3, 50), new DLinear(8.0, 25.0), 0.3f, drugs), "drugs", false);
            try {
                PandorasBoxHelper.addItems(100, Psychedelicraft.modItem("hop_seeds"), Psychedelicraft.modItem("hop_cones"), Psychedelicraft.modItem("wineGrapes"), Psychedelicraft.modItem("cannabisSeeds"), Psychedelicraft.modItem("cannabisLeaf"), Psychedelicraft.modItem("cannabisBuds"), Psychedelicraft.modItem("tobaccoSeeds"), Psychedelicraft.modItem("tobaccoLeaf"), Psychedelicraft.modItem("cocaSeeds"), Psychedelicraft.modItem("cocaLeaf"), Psychedelicraft.modItem("juniperBerries"), Psychedelicraft.modItem("coffeaCherries"), Psychedelicraft.modItem("peyote"));
                PandorasBoxHelper.addItems(80, Psychedelicraft.modItem("hashMuffin"), Psychedelicraft.modItem("brownMagicMushrooms"), Psychedelicraft.modItem("redMagicMushrooms"), Psychedelicraft.modItem("cigarette"), Psychedelicraft.modItem("cigar"), Psychedelicraft.modItem("joint"), Psychedelicraft.modItem("cocaine_powder"), Psychedelicraft.modItem("peyoteJoint"));
                PandorasBoxHelper.addItems(80, Psychedelicraft.modItem("stone_cup"), Psychedelicraft.modItem("woodenMug"), Psychedelicraft.modItem("glassChalice"), Psychedelicraft.modItem("bottle"), Psychedelicraft.modItem("smokingPipe"));
                PandorasBoxHelper.addItems(60, Psychedelicraft.modItem("barrel"), Psychedelicraft.modItem("mash_tub"), Psychedelicraft.modItem("flask"), Psychedelicraft.modItem("distillery"));
                PandorasBoxHelper.addItems(30, Psychedelicraft.modItem("syringe"), Psychedelicraft.modItem("bong"));
            }
            catch (Exception ex) {
                PandorasBox.logger.error("Incompatible Psychedelicraft Compatibility", (Throwable)ex);
            }
        }
    }

    public static void initEffects() {
        PBEffectRegistry.register(PBEffectEntitiesDrug.class, "drugEntities");
    }

    public static void addDrugValue(Entity entity, String drug, float value) {
        NBTTagCompound message = new NBTTagCompound();
        message.func_74768_a("worldID", entity.field_71093_bK);
        message.func_74768_a("entityID", entity.func_145782_y());
        message.func_74778_a("drugName", drug);
        message.func_74776_a("drugValue", value);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"drugAddValue", (NBTTagCompound)message);
    }

    public static class WeightedDrug
    extends WeightedRandom.Item {
        public String drugName;
        public float minAddValue;
        public float maxAddValue;

        public WeightedDrug(int weight, String drugName, float minAddValue, float maxAddValue) {
            super(weight);
            this.drugName = drugName;
            this.minAddValue = minAddValue;
            this.maxAddValue = maxAddValue;
        }
    }
}

