/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import toast.mobProperties.MobDrops;
import toast.mobProperties.MobStats;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public abstract class EffectHelper {
    private static final String TAG_INIT = "MP|Init";
    private static final String TAG_BASE = "mp|drops";
    private static final String TAG_PRE_STATS = "pfs";
    private static final String TAG_STATS = "sfs";
    private static final String TAG_DROPS = "dfs";
    private static final String TAG_XP_BASE = "xpb";
    private static final String TAG_XP_ADD = "xpa";
    private static final String TAG_XP_MULT = "xpm";
    @Deprecated
    private static final String TAG_ADD_DROPS = "add";
    @Deprecated
    private static final String TAG_SPAWNS = "ent";

    public static void enchantItem(ItemStack itemStack, int id, int level) {
        if (Enchantment.field_77331_b[id] != null) {
            itemStack.func_77966_a(Enchantment.field_77331_b[id], level);
        }
    }

    public static void enchantItem(ItemStack itemStack, int level) {
        EffectHelper.enchantItem(_MobPropertiesMod.random, itemStack, level);
    }

    public static void enchantItem(Random random, ItemStack itemStack, int level) {
        EnchantmentHelper.func_77504_a((Random)random, (ItemStack)itemStack, (int)level);
    }

    public static void addItemText(ItemStack itemStack, String text) {
        NBTTagCompound displayTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_150297_b("display", 10)) {
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(displayTag = itemStack.field_77990_d.func_74775_l("display")).func_150297_b("Lore", 9)) {
            displayTag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagString stringTag = new NBTTagString(text);
        displayTag.func_150295_c("Lore", 8).func_74742_a((NBTBase)stringTag);
    }

    public static void dye(ItemStack itemStack, int color) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_150297_b("display", 10)) {
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74775_l("display").func_74768_a("color", color);
    }

    public static void addPotionEffect(EntityLivingBase entity, int id, int duration, int amplifier, boolean ambient) {
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70109_d(tag);
        if (!tag.func_150297_b("ActiveEffects", 9)) {
            tag.func_74782_a("ActiveEffects", (NBTBase)new NBTTagList());
        }
        NBTTagCompound potionTag = new NBTTagCompound();
        if (id != 0) {
            potionTag.func_74774_a("Id", (byte)id);
        }
        if (duration != 0) {
            potionTag.func_74768_a("Duration", duration);
        }
        if (amplifier != 0) {
            potionTag.func_74774_a("Amplifier", (byte)amplifier);
        }
        if (ambient) {
            potionTag.func_74757_a("Ambient", ambient);
        }
        tag.func_150295_c("ActiveEffects", 10).func_74742_a((NBTBase)potionTag);
        entity.func_70020_e(tag);
    }

    public static void addPotionEffect(ItemStack itemStack, int id, int duration, int amplifier, boolean ambient) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        if (!itemStack.field_77990_d.func_150297_b("CustomPotionEffects", 9)) {
            itemStack.field_77990_d.func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Id", (byte)id);
        tag.func_74768_a("Duration", duration);
        tag.func_74774_a("Amplifier", (byte)amplifier);
        tag.func_74757_a("Ambient", ambient);
        itemStack.field_77990_d.func_150295_c("CustomPotionEffects", 10).func_74742_a((NBTBase)tag);
    }

    public static void addModifier(ItemStack itemStack, String attribute, double value, int operation) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        if (!itemStack.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            itemStack.field_77990_d.func_74782_a("AttributeModifiers", (NBTBase)new NBTTagList());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("AttributeName", attribute);
        tag.func_74778_a("Name", "MobProperties|" + Integer.toString(_MobPropertiesMod.random.nextInt(), 36));
        tag.func_74780_a("Amount", value);
        tag.func_74768_a("Operation", operation);
        UUID id = UUID.randomUUID();
        tag.func_74772_a("UUIDMost", id.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", id.getLeastSignificantBits());
        itemStack.field_77990_d.func_150295_c("AttributeModifiers", 10).func_74742_a((NBTBase)tag);
    }

    public static void setInit(Entity entity, int state) {
        entity.getEntityData().func_74774_a(TAG_INIT, (byte)state);
    }

    public static byte getInit(Entity entity) {
        return entity.getEntityData().func_74771_c(TAG_INIT);
    }

    public static void saveXP(MobDropsInfo mobDrops) {
        EffectHelper.saveXP(mobDrops.theEntity, mobDrops.xpBase, mobDrops.xpAdd, mobDrops.xpMult);
    }

    private static void saveXP(EntityLivingBase entity, int base, int add, double mult) {
        if (entity instanceof EntityLiving) {
            NBTTagCompound tag = entity.getEntityData().func_74775_l(TAG_BASE);
            if (!entity.getEntityData().func_150297_b(TAG_BASE, 10)) {
                entity.getEntityData().func_74782_a(TAG_BASE, (NBTBase)tag);
            }
            if (base >= 0) {
                tag.func_74768_a(TAG_XP_BASE, base);
            } else {
                tag.func_82580_o(TAG_XP_BASE);
            }
            if (add != 0) {
                tag.func_74768_a(TAG_XP_ADD, add);
            } else {
                tag.func_82580_o(TAG_XP_ADD);
            }
            if (mult != 1.0) {
                tag.func_74780_a(TAG_XP_MULT, mult);
            } else {
                tag.func_82580_o(TAG_XP_MULT);
            }
        }
    }

    public static void loadXP(MobDropsInfo mobDrops) {
        if (mobDrops.theEntity instanceof EntityLiving) {
            if (!mobDrops.theEntity.getEntityData().func_150297_b(TAG_BASE, 10)) {
                return;
            }
            NBTTagCompound tag = mobDrops.theEntity.getEntityData().func_74775_l(TAG_BASE);
            if (tag.func_150297_b(TAG_XP_BASE, 3)) {
                mobDrops.xpBase = tag.func_74762_e(TAG_XP_BASE);
            }
            if (tag.func_150297_b(TAG_XP_ADD, 3)) {
                mobDrops.xpAdd = tag.func_74762_e(TAG_XP_ADD);
            }
            if (tag.func_150297_b(TAG_XP_MULT, 6)) {
                mobDrops.xpMult = tag.func_74769_h(TAG_XP_MULT);
            }
        }
    }

    public static void loadXP(EntityLivingBase entity) {
        if (entity instanceof EntityLiving) {
            if (!entity.getEntityData().func_150297_b(TAG_BASE, 10)) {
                return;
            }
            NBTTagCompound tag = entity.getEntityData().func_74775_l(TAG_BASE);
            if (tag.func_150297_b(TAG_XP_BASE, 3) || tag.func_150297_b(TAG_XP_ADD, 3) || tag.func_150297_b(TAG_XP_MULT, 6)) {
                String[] fieldNames = new String[]{"field_70728_aV", "experienceValue"};
                int exp = tag.func_150297_b(TAG_XP_BASE, 3) ? tag.func_74762_e(TAG_XP_BASE) : ((Integer)ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, (Object)((EntityLiving)entity), (String[])fieldNames)).intValue();
                if (tag.func_150297_b(TAG_XP_ADD, 3)) {
                    exp += tag.func_74762_e(TAG_XP_ADD);
                }
                if (tag.func_150297_b(TAG_XP_MULT, 6)) {
                    exp = (int)Math.round((double)exp * tag.func_74769_h(TAG_XP_MULT));
                }
                if (exp < 0) {
                    exp = 0;
                }
                ObfuscationReflectionHelper.setPrivateValue(EntityLiving.class, (Object)((EntityLiving)entity), (Object)exp, (String[])fieldNames);
            }
        }
    }

    public static void loadStats(EntityLivingBase entity, boolean preStats) {
        String tagName;
        if (!entity.getEntityData().func_150297_b(TAG_BASE, 10)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData().func_74775_l(TAG_BASE);
        String string = tagName = preStats ? TAG_PRE_STATS : TAG_STATS;
        if (tag.func_150297_b(tagName, 9)) {
            MobStatsInfo mobStats = new MobStatsInfo(entity);
            new MobStats(entity.getClass().getName(), tag.func_150295_c(tagName, 8)).init(mobStats);
            mobStats.save();
        }
    }

    public static void saveDrops(MobStatsInfo mobStats) {
        if (mobStats.addDropsList.size() == 0) {
            return;
        }
        NBTTagCompound tag = mobStats.theEntity.getEntityData().func_74775_l(TAG_BASE);
        if (!mobStats.theEntity.getEntityData().func_150297_b(TAG_BASE, 10)) {
            mobStats.theEntity.getEntityData().func_74782_a(TAG_BASE, (NBTBase)tag);
        }
        NBTTagList dropList = tag.func_150295_c(TAG_DROPS, 8);
        if (!tag.func_150297_b(TAG_DROPS, 9)) {
            tag.func_74782_a(TAG_DROPS, (NBTBase)dropList);
        }
        for (String dropsFunction : mobStats.addDropsList) {
            dropList.func_74742_a((NBTBase)new NBTTagString(dropsFunction));
        }
    }

    public static void loadDrops(MobDropsInfo mobDrops) {
        if (!mobDrops.theEntity.getEntityData().func_150297_b(TAG_BASE, 10)) {
            return;
        }
        NBTTagCompound tag = mobDrops.theEntity.getEntityData().func_74775_l(TAG_BASE);
        if (tag.func_150297_b(TAG_DROPS, 9)) {
            new MobDrops(mobDrops.theEntity.getClass().getName(), tag.func_150295_c(TAG_DROPS, 8)).modifyDrops(mobDrops);
        }
    }

    @Deprecated
    public static void loadLegacyDrops(EntityLivingBase entity, ArrayList<EntityItem> drops) {
        int length;
        if (!entity.getEntityData().func_150297_b(TAG_BASE, 10)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData().func_74775_l(TAG_BASE);
        if (tag.func_150297_b(TAG_ADD_DROPS, 9)) {
            NBTTagList dropList = tag.func_150295_c(TAG_ADD_DROPS, 10);
            length = dropList.func_74745_c();
            for (int i = 0; i < length; ++i) {
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)dropList.func_150305_b(i));
                if (itemStack == null || itemStack.field_77994_a == 0) continue;
                if (itemStack.field_77994_a > 0) {
                    int count = itemStack.field_77994_a;
                    itemStack.field_77994_a = 1;
                    while (count-- > 0) {
                        EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack.func_77946_l());
                        drop.field_145804_b = 10;
                        drops.add(drop);
                    }
                    continue;
                }
                EffectHelper.removeDrop(itemStack, entity, drops);
            }
        }
        if (tag.func_150297_b(TAG_SPAWNS, 9)) {
            NBTTagList spawnList = tag.func_150295_c(TAG_SPAWNS, 10);
            length = spawnList.func_74745_c();
            for (int i = 0; i < length; ++i) {
                Entity mob = EntityList.func_75615_a((NBTTagCompound)spawnList.func_150305_b(i), (World)entity.field_70170_p);
                if (mob == null) continue;
                mob.field_70177_z += entity.field_70177_z;
                mob.func_70107_b(entity.field_70165_t + mob.field_70165_t, entity.field_70163_u + mob.field_70163_u, entity.field_70161_v + mob.field_70161_v);
                entity.field_70170_p.func_72838_d(mob);
            }
        }
    }

    @Deprecated
    private static void removeDrop(ItemStack itemStack, EntityLivingBase entity, ArrayList<EntityItem> drops) {
        boolean infinite = itemStack.field_77994_a == -2147483647;
        EffectHelper.removeDrop(itemStack, infinite, entity, drops);
    }

    @Deprecated
    private static int removeDrop(ItemStack itemStack, boolean infinite, EntityLivingBase entity, ArrayList<EntityItem> drops) {
        Iterator<EntityItem> iterator = drops.iterator();
        while (iterator.hasNext()) {
            EntityItem drop = iterator.next();
            ItemStack dropStack = drop.func_92059_d();
            if (itemStack.func_77973_b() != dropStack.func_77973_b() || itemStack.func_77960_j() >= 0 && itemStack.func_77960_j() != dropStack.func_77960_j()) continue;
            if (infinite) {
                iterator.remove();
                continue;
            }
            itemStack.field_77994_a += dropStack.field_77994_a;
            if (itemStack.field_77994_a < 0) {
                iterator.remove();
                continue;
            }
            if (itemStack.field_77994_a == 0) {
                iterator.remove();
                return 0;
            }
            dropStack.field_77994_a = itemStack.field_77994_a;
            drop.func_92058_a(dropStack);
            return 0;
        }
        return itemStack.field_77994_a;
    }
}

