/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.FileHelper;
import toast.mobProperties.MobProperties;
import toast.mobProperties.Properties;
import toast.mobProperties.TickHandler;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EventHandler {
    public static final boolean DISABLED = Properties.getBoolean("_general", "disable");

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityLivingBase && !(event.entity instanceof EntityPlayer) && !DISABLED) {
            MobProperties mobProps;
            EffectHelper.loadXP((EntityLivingBase)event.entity);
            byte initDat = EffectHelper.getInit(event.entity);
            if (initDat <= 0 && (mobProps = MobProperties.getProperties((EntityLivingBase)event.entity)) != null) {
                if (initDat == 0) {
                    EffectHelper.loadStats((EntityLivingBase)event.entity, true);
                    if (!event.entity.func_70089_S()) {
                        event.setCanceled(true);
                        return;
                    }
                    initDat = EffectHelper.getInit(event.entity);
                    if (initDat == 0) {
                        EffectHelper.setInit(event.entity, -1);
                        MobStatsInfo mobStats = new MobStatsInfo((EntityLivingBase)event.entity);
                        mobProps.preInit(mobStats);
                        mobStats.save();
                        if (!event.entity.func_70089_S()) {
                            event.setCanceled(true);
                            return;
                        }
                        initDat = EffectHelper.getInit(event.entity);
                        if (initDat > 0) {
                            return;
                        }
                    }
                }
                TickHandler.markForInit((EntityLivingBase)event.entity, mobProps);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            MobProperties props = MobProperties.getProperties(event.entityLiving);
            MobDropsInfo mobDrops = new MobDropsInfo(event.entityLiving, event.source, event.drops, event.lootingLevel, event.recentlyHit, event.specialDropValue);
            if (props != null) {
                props.modifyDrops(mobDrops);
            }
            EffectHelper.loadDrops(mobDrops);
            mobDrops.applyDefaultAndAddDrops();
            EffectHelper.loadLegacyDrops(event.entityLiving, event.drops);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        ItemStack held;
        if (event.target != null && event.entityPlayer != null && !event.entityPlayer.field_70170_p.field_72995_K && (held = event.entityPlayer.func_70694_bm()) != null && held.func_77973_b() == Items.field_151055_y && held.field_77990_d != null && held.field_77990_d.func_74767_n("MP|InfoWand")) {
            float offset = event.target.field_70139_V;
            double x = event.target.field_70165_t;
            double y = event.target.field_70163_u;
            double z = event.target.field_70161_v;
            event.target.field_70139_V = 0.0f;
            event.target.field_70161_v = 0.0;
            event.target.field_70163_u = 0.0;
            event.target.field_70165_t = 0.0;
            NBTTagCompound tag = new NBTTagCompound();
            event.target.func_70109_d(tag);
            tag.func_82580_o("Dimension");
            tag.func_82580_o("UUIDMost");
            tag.func_82580_o("UUIDLeast");
            event.target.field_70139_V = offset;
            event.target.field_70165_t = x;
            event.target.field_70163_u = y;
            event.target.field_70161_v = z;
            File generated = FileHelper.generateNbtStats(event.target.func_70005_c_(), tag);
            if (generated != null) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("[Info Wand] Generated external nbt stats file \"" + generated.getName().substring(0, generated.getName().length() - ".json".length()) + "\" at:"));
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("    " + generated.getAbsolutePath()));
            } else {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("[Info Wand] Failed to generate external nbt stats file!"));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack held;
        if (event.world != null && event.y >= 0 && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer != null && !event.entityPlayer.field_70170_p.field_72995_K && (held = event.entityPlayer.func_70694_bm()) != null && held.func_77973_b() == Items.field_151055_y && held.field_77990_d != null && held.field_77990_d.func_74767_n("MP|InfoWand")) {
            TileEntity tileEntity = event.world.func_147438_o(event.x, event.y, event.z);
            if (tileEntity == null) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tileEntity.func_145841_b(tag);
            String name = tag.func_74779_i("id");
            tag.func_82580_o("id");
            tag.func_82580_o("x");
            tag.func_82580_o("y");
            tag.func_82580_o("z");
            if (tag.func_82582_d()) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("[Info Wand] Tile entity has no usable tags!"));
                return;
            }
            File generated = FileHelper.generateNbtStats(name, tag);
            if (generated != null) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("[Info Wand] Generated external nbt stats file \"" + generated.getName().substring(0, generated.getName().length() - ".json".length()) + "\" at:"));
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("    " + generated.getAbsolutePath()));
            } else {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("[Info Wand] Failed to generate external nbt stats file!"));
            }
        }
    }
}

