/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.ItemStats;

public class MobDropsInfo {
    public final EntityLivingBase theEntity;
    public final Random random;
    public final DamageSource theSource;
    public final ArrayList<EntityItem> dropsList;
    public final ArrayList<EntityItem> addDropsList = new ArrayList();
    public final int looting;
    public final boolean recentlyHit;
    public final boolean rare;
    public final boolean superRare;
    public byte defaultBehavior = 1;
    public int xpBase = -1;
    public int xpAdd = 0;
    public double xpMult = 1.0;

    public MobDropsInfo(EntityLivingBase entity, DamageSource source, ArrayList<EntityItem> drops, int lootingLevel, boolean recentHit, int specialDropValue) {
        this.theEntity = entity;
        this.random = entity.func_70681_au();
        this.theSource = source;
        this.dropsList = drops;
        this.looting = lootingLevel;
        this.recentlyHit = recentHit;
        if (this.recentlyHit) {
            this.rare = specialDropValue < 5;
            this.superRare = specialDropValue <= 0;
        } else {
            this.rare = false;
            this.superRare = false;
        }
        EffectHelper.loadXP(this);
    }

    public void addDrop(Item item, int damage, int count, ItemStats itemStats) {
        ItemStack dropStack;
        ItemStack itemStack = dropStack = itemStats == null ? new ItemStack(item, 1, damage) : itemStats.generate(this.theEntity, item, damage, this);
        if (dropStack.func_77973_b() != null) {
            if (count > 0) {
                while (count-- > 0) {
                    EntityItem drop = new EntityItem(this.theEntity.field_70170_p, this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, dropStack.func_77946_l());
                    drop.field_145804_b = 10;
                    this.addDropsList.add(drop);
                }
            } else if (count < 0) {
                this.removeDrop(item, damage, count);
            }
        }
    }

    private void removeDrop(Item item, int damage, int count) {
        boolean infinite = count == -2147483647;
        count = this.removeDrop(item, damage, count, infinite, this.addDropsList);
        if (infinite || count < 0) {
            this.removeDrop(item, damage, count, infinite, this.dropsList);
        }
    }

    private int removeDrop(Item item, int damage, int count, boolean infinite, ArrayList<EntityItem> drops) {
        Iterator<EntityItem> iterator = drops.iterator();
        while (iterator.hasNext()) {
            EntityItem drop = iterator.next();
            ItemStack dropStack = drop.func_92059_d();
            if (item != dropStack.func_77973_b() || damage >= 0 && damage != dropStack.func_77960_j()) continue;
            if (infinite) {
                iterator.remove();
                continue;
            }
            if ((count += dropStack.field_77994_a) < 0) {
                iterator.remove();
                continue;
            }
            if (count == 0) {
                iterator.remove();
                return 0;
            }
            dropStack.field_77994_a = count;
            drop.func_92058_a(dropStack);
            return 0;
        }
        return count;
    }

    public void applyDefaultAndAddDrops() {
        switch (this.defaultBehavior) {
            case 1: {
                break;
            }
            case 0: {
                this.dropsList.clear();
                break;
            }
            case 2: {
                Iterator<EntityItem> iterator = this.dropsList.iterator();
                while (iterator.hasNext()) {
                    EntityItem drop = iterator.next();
                    if (drop.func_92059_d().func_77984_f()) continue;
                    iterator.remove();
                }
                break;
            }
        }
        this.dropsList.addAll(this.addDropsList);
        EffectHelper.saveXP(this);
        EffectHelper.loadXP(this.theEntity);
    }
}

