/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTStatsInfo {
    public final Object parent;
    public final ItemStack theItem;
    public final EntityLivingBase theEntity;
    public final Random random;
    private final ArrayList<NBTWrapper> tags = new ArrayList();

    public NBTStatsInfo(ItemStack item, EntityLivingBase entity, Object mobInfo) {
        this.parent = mobInfo;
        this.theItem = item;
        this.theEntity = entity;
        this.random = entity.func_70681_au();
    }

    public void addTag(String name, NBTBase tag) {
        this.tags.add(new NBTWrapper(name, tag));
    }

    public NBTTagCompound writeTo(NBTTagCompound compound) {
        for (NBTWrapper wrapper : this.tags) {
            if (wrapper.getTag() == null) {
                compound.func_82580_o(wrapper.getName());
                continue;
            }
            if (wrapper.getTag().getClass() == NBTTagCompound.class) {
                this.writeCompound(compound, wrapper);
                continue;
            }
            compound.func_74782_a(wrapper.getName(), wrapper.getTag());
        }
        return compound;
    }

    public NBTTagList writeTo(NBTTagList list) {
        for (NBTWrapper wrapper : this.tags) {
            if (wrapper.getTag() == null) {
                list.func_74744_a(list.func_74745_c() - 1);
                continue;
            }
            list.func_74742_a(wrapper.getTag());
        }
        return list;
    }

    private void writeCompound(NBTTagCompound compound, NBTWrapper wrapper) {
        NBTTagCompound copyTo = compound.func_74775_l(wrapper.getName());
        if (!compound.func_150297_b(wrapper.getName(), 10)) {
            compound.func_74782_a(wrapper.getName(), (NBTBase)copyTo);
        }
        NBTTagCompound copyFrom = (NBTTagCompound)wrapper.getTag();
        for (String name : copyFrom.func_150296_c()) {
            NBTBase tag = copyFrom.func_74781_a(name);
            if (tag.getClass() == NBTTagCompound.class) {
                this.writeCompound(copyTo, new NBTWrapper(name, tag));
                continue;
            }
            copyTo.func_74782_a(name, tag.func_74737_b());
        }
    }

    private static class NBTWrapper {
        private final String name;
        private final NBTBase tag;

        public NBTWrapper(String name, NBTBase tag) {
            this.name = name;
            this.tag = tag;
        }

        public String getName() {
            return this.name;
        }

        public NBTBase getTag() {
            return this.tag;
        }
    }
}

