/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.nbt;

import com.google.gson.JsonObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.NBTStatsInfo;

public class EntryNBTByte
extends EntryAbstract {
    private final String name;
    private final double[] values;

    public EntryNBTByte(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader, boolean isBoolean) {
        super(node, path);
        this.name = FileHelper.readText(node, path, "name", "");
        if (isBoolean) {
            double[] dArray;
            if (FileHelper.readBoolean(node, path, "value", false)) {
                double[] dArray2 = new double[2];
                dArray2[0] = 1.0;
                dArray = dArray2;
                dArray2[1] = 1.0;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = 0.0;
                dArray = dArray3;
                dArray3[1] = 0.0;
            }
            this.values = dArray;
        } else {
            this.values = FileHelper.readCounts(node, path, "value", 0.0, 0.0);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[0];
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"name", "value"};
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        int value = FileHelper.getCount(this.values, nbtStats.random);
        nbtStats.addTag(this.name, (NBTBase)new NBTTagByte((byte)value));
    }
}

