/*
 * Decompiled with CFR 0.152.
 */
package tehnut.morechisels.item.chisel;

import cofh.api.energy.IEnergyContainerItem;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tehnut.morechisels.ConfigHandler;
import tehnut.morechisels.item.ChiselType;
import tehnut.morechisels.item.ItemChiselBase;
import tehnut.morechisels.util.Utils;

public class ItemChiselFluxed
extends ItemChiselBase
implements IEnergyContainerItem {
    private static int capacity = ConfigHandler.durabilityFluxed;

    public ItemChiselFluxed() {
        super(ChiselType.FLUXED);
        this.setNoRepair();
        this.func_77656_e(0);
        this.hasModes = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(Utils.setNewEnergyTag(new ItemStack(item, 1), 0));
        list.add(Utils.setNewEnergyTag(new ItemStack(item, 1), capacity));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int currentEnergy = stack.field_77990_d.func_74762_e("Energy");
        return 1.0 - (double)currentEnergy / (double)capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        list.add(ItemChiselFluxed.getEnergyColor(StatCollector.func_74837_a((String)"tip.morechisels.energy", (Object[])new Object[]{stack.field_77990_d.func_74762_e("Energy"), this.getMaxEnergyStored(stack)}), stack));
    }

    private static String getEnergyColor(String string, ItemStack stack) {
        int currentEnergy;
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((double)(currentEnergy = stack.field_77990_d.func_74762_e("Energy")) < (double)capacity * 0.25) {
            return EnumChatFormatting.RED + string;
        }
        if ((double)currentEnergy < (double)capacity * 0.5) {
            return EnumChatFormatting.GOLD + string;
        }
        if ((double)currentEnergy < (double)capacity * 0.75) {
            return EnumChatFormatting.YELLOW + string;
        }
        return EnumChatFormatting.GREEN + string;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(capacity - energy, Math.min(200, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(200, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        NBTTagCompound tag = container.field_77990_d;
        if (tag == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        return tag.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return capacity;
    }

    @Override
    public boolean onChisel(World world, ItemStack chisel, ICarvingVariation target) {
        NBTTagCompound tag = chisel.field_77990_d;
        if (tag == null) {
            chisel.func_77982_d(new NBTTagCompound());
        }
        this.extractEnergy(chisel, 200, false);
        return false;
    }

    @Override
    public boolean canChisel(World world, ItemStack chisel, ICarvingVariation target) {
        NBTTagCompound tag = chisel.field_77990_d;
        if (tag == null) {
            chisel.func_77982_d(new NBTTagCompound());
        }
        return tag.func_74762_e("Energy") > 0;
    }

    @Override
    public boolean canChiselBlock(World world, EntityPlayer player, int x, int y, int z, Block block, int metadata) {
        ItemStack stack = player.func_70694_bm();
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return tag.func_74762_e("Energy") > 0;
    }

    @Override
    public boolean canOpenGui(World world, EntityPlayer player, ItemStack chisel) {
        NBTTagCompound tag = chisel.field_77990_d;
        if (tag == null) {
            chisel.func_77982_d(new NBTTagCompound());
        }
        return tag.func_74762_e("Energy") > 0;
    }
}

