/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientUtils {
    public static final float ITEM_PIXEL = 0.03125f;

    public static void push() {
        GL11.glPushMatrix();
    }

    public static void pop() {
        GL11.glPopMatrix();
    }

    public static void bind(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static void translate(double x, double y, double z) {
        GL11.glTranslated((double)x, (double)y, (double)z);
    }

    public static void translate(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void rotate(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void rotate(int angle) {
        ClientUtils.rotate(4, angle);
    }

    public static void rotate(int angles, int angle) {
        float degrees = (float)angle / (float)angles;
        ClientUtils.rotate(-360.0f * degrees, 0.0f, 1.0f, 0.0f);
    }

    public static void scale(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void scale(float scale) {
        ClientUtils.scale(scale, scale, scale);
    }

    public static void color(int color) {
        ClientUtils.colorRGB(ClientUtils.toRGB(color));
    }

    public static void colorRGB(float[] rgb) {
        ClientUtils.color(rgb[0], rgb[1], rgb[2]);
    }

    public static void color(float r, float g, float b) {
        GL11.glColor3f((float)r, (float)g, (float)b);
    }

    public static void color(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static ResourceLocation modelTexture(String name) {
        return ModInfo.toLocation(String.format("textures/models/%s.png", name));
    }

    public static void enableTextures() {
        GL11.glEnable((int)3553);
    }

    public static float fromDegrees(float degrees) {
        return (float)Math.toRadians(degrees);
    }

    public static void renderItemStack(ItemStack stack) {
        if (stack != null) {
            ClientUtils.push();
            EntityItem item = new EntityItem(ClientUtils.getClientWorld(), 0.0, 0.0, 0.0, stack);
            item.field_70290_d = 0.0f;
            RenderItem.field_82407_g = false;
            ClientUtils.translate(0.0f, -0.22475f, -0.006f);
            RenderManager.field_78727_a.func_147940_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            ClientUtils.pop();
        }
    }

    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71439_g.func_130014_f_();
    }

    public static float[] toRGB(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }
}

