/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import com.google.gson.Gson;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.ModConfig;
import dk.mrspring.kitchen.api.KitchenRegistry;
import dk.mrspring.kitchen.config.SandwichableConfig;
import dk.mrspring.kitchen.pan.Ingredient;
import dk.mrspring.kitchen.pan.ItemBaseRenderingHandler;
import dk.mrspring.kitchen.pan.Jam;
import dk.mrspring.kitchen.pan.JamBaseRenderingHandler;
import dk.mrspring.kitchen.recipe.OvenRecipes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IMCHandler {
    public static void handleMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equalsIgnoreCase("linkItemAndIngredient")) {
            IMCHandler.handleLinkMessage(message);
        } else if (message.key.equalsIgnoreCase("makeItemSandwichable")) {
            IMCHandler.handleMakeSandwichableMessage(message);
        } else if (message.key.equalsIgnoreCase("addOvenRecipe")) {
            IMCHandler.handleOvenRecipeMessage(message);
        } else if (message.key.equalsIgnoreCase("addPanRecipe")) {
            IMCHandler.handlePanRecipeMessage(message);
        } else if (message.key.equalsIgnoreCase("addJam")) {
            IMCHandler.handleJamMessage(message);
        }
    }

    public static void handleLinkMessage(FMLInterModComms.IMCMessage message) {
        if (message.isStringMessage()) {
            String messageText = message.getStringValue();
            if (messageText.contains(",")) {
                String itemName = messageText.split(",")[0];
                String ingredientName = messageText.split(",")[1];
                KitchenRegistry.linkItemToIngredient(GameRegistry.findItem((String)itemName.split(":")[0], (String)itemName.split(":")[1]), ingredientName);
            }
        } else if (message.isNBTMessage()) {
            String itemName;
            NBTTagCompound infoCompound = message.getNBTValue();
            if (!infoCompound.func_150297_b("IngredientName", 8)) {
                return;
            }
            String ingredientName = infoCompound.func_74779_i("IngredientName");
            if (infoCompound.func_150297_b("Item", 8)) {
                itemName = infoCompound.func_74779_i("Item");
                if (!itemName.contains(":")) {
                    return;
                }
            } else if (infoCompound.func_150297_b("Item", 10)) {
                NBTTagCompound itemCompound = infoCompound.func_74775_l("Item");
                if (itemCompound == null) {
                    return;
                }
                ItemStack compoundItem = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
                if (compoundItem == null) {
                    return;
                }
                itemName = GameRegistry.findUniqueIdentifierFor((Item)compoundItem.func_77973_b()).toString();
            } else {
                return;
            }
            KitchenRegistry.linkItemToIngredient(itemName, ingredientName);
        }
    }

    public static void handleMakeSandwichableMessage(FMLInterModComms.IMCMessage message) {
        if (message.isStringMessage()) {
            String jsonCode = message.getStringValue();
            Gson gson = new Gson();
            SandwichableConfig.SandwichableEntry entry = (SandwichableConfig.SandwichableEntry)gson.fromJson(jsonCode, SandwichableConfig.SandwichableEntry.class);
            ModConfig.getSandwichConfig().makeSandwichable(entry);
        } else if (message.isNBTMessage()) {
            String itemName;
            NBTTagCompound entryCompound = message.getNBTValue();
            boolean isBread = false;
            boolean hideInformation = false;
            if (entryCompound.func_150297_b("Item", 8)) {
                itemName = entryCompound.func_74779_i("Item");
            } else if (entryCompound.func_150297_b("Item", 10)) {
                NBTTagCompound itemCompound = entryCompound.func_74775_l("Item");
                if (itemCompound == null) {
                    return;
                }
                ItemStack compoundItem = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
                if (compoundItem == null) {
                    return;
                }
                itemName = GameRegistry.findUniqueIdentifierFor((Item)compoundItem.func_77973_b()).toString();
            } else {
                return;
            }
            if (!entryCompound.func_150297_b("HealAmount", 3)) {
                return;
            }
            int healAmount = entryCompound.func_74762_e("HealAmount");
            if (entryCompound.func_150297_b("IsBread", 1)) {
                isBread = entryCompound.func_74767_n("IsBread");
            }
            if (entryCompound.func_150297_b("HideInformation", 1)) {
                hideInformation = entryCompound.func_74767_n("HideInformation");
            }
            SandwichableConfig.SandwichableEntry entry = new SandwichableConfig.SandwichableEntry(itemName, healAmount, isBread);
            if (hideInformation) {
                entry.hideInformation();
            }
            ModConfig.getSandwichConfig().makeSandwichable(entry);
        }
    }

    public static void handleOvenRecipeMessage(FMLInterModComms.IMCMessage message) {
        String messageText;
        if (message.isNBTMessage()) {
            NBTTagCompound messageCompound = message.getNBTValue();
            if (!messageCompound.func_150297_b("Input", 10)) {
                return;
            }
            NBTTagCompound inputCompound = messageCompound.func_74775_l("Input");
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)inputCompound);
            if (!messageCompound.func_150297_b("Output", 10)) {
                return;
            }
            NBTTagCompound outputCompound = messageCompound.func_74775_l("Output");
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)outputCompound);
            OvenRecipes.addRecipe(input, output);
        } else if (message.isStringMessage() && (messageText = message.getStringValue()).contains(",")) {
            String inputName = messageText.split(",")[0];
            String outputName = messageText.split(",")[1];
            if (!inputName.contains(":") || !outputName.contains(":")) {
                return;
            }
            ItemStack input = new ItemStack(GameRegistry.findItem((String)inputName.split(":")[0], (String)inputName.split(":")[1]));
            ItemStack output = new ItemStack(GameRegistry.findItem((String)outputName.split(":")[0], (String)outputName.split(":")[1]));
            OvenRecipes.addRecipe(input, output);
        }
    }

    public static void handlePanRecipeMessage(FMLInterModComms.IMCMessage message) {
        String messageText;
        if (message.isNBTMessage()) {
            NBTTagCompound messageCompound = message.getNBTValue();
            if (!messageCompound.func_150297_b("Input", 10)) {
                return;
            }
            NBTTagCompound inputCompound = messageCompound.func_74775_l("Input");
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)inputCompound);
            if (!messageCompound.func_150297_b("Output", 10)) {
                return;
            }
            NBTTagCompound outputCompound = messageCompound.func_74775_l("Output");
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)outputCompound);
            String ingredientName = GameRegistry.findUniqueIdentifierFor((Item)input.func_77973_b()).toString() + "-" + GameRegistry.findUniqueIdentifierFor((Item)output.func_77973_b()).toString();
            Ingredient ingredient = new Ingredient(ingredientName, "ingredient." + ingredientName + ".name", output);
            Ingredient.registerIngredient(ingredient);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ingredient.setRenderingHandler(new ItemBaseRenderingHandler(input, output));
            }
            KitchenItems.linkToIngredient(input.func_77973_b(), ingredientName);
        } else if (message.isStringMessage() && (messageText = message.getStringValue()).contains(",")) {
            String inputName = messageText.split(",")[0];
            String outputName = messageText.split(",")[1];
            if (!inputName.contains(":") || !outputName.contains(":")) {
                return;
            }
            ItemStack input = new ItemStack(GameRegistry.findItem((String)inputName.split(":")[0], (String)inputName.split(":")[1]));
            ItemStack output = new ItemStack(GameRegistry.findItem((String)outputName.split(":")[0], (String)outputName.split(":")[1]));
            String ingredientName = GameRegistry.findUniqueIdentifierFor((Item)input.func_77973_b()).toString() + "-" + GameRegistry.findUniqueIdentifierFor((Item)output.func_77973_b()).toString();
            Ingredient ingredient = new Ingredient(ingredientName, "ingredient." + ingredientName + ".name", output);
            Ingredient.registerIngredient(ingredient);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ingredient.setRenderingHandler(new ItemBaseRenderingHandler(input, output));
            }
            KitchenItems.linkToIngredient(input.func_77973_b(), ingredientName);
        }
    }

    public static void handleJamMessage(FMLInterModComms.IMCMessage message) {
        if (message.isNBTMessage()) {
            String jamItemName;
            ItemStack stackFromCompound;
            NBTTagCompound itemCompound;
            String inputItemName;
            NBTTagCompound messageCompound = message.getNBTValue();
            if (!messageCompound.func_150297_b("JamName", 8)) {
                return;
            }
            String jamName = messageCompound.func_74779_i("JamName");
            if (!messageCompound.func_150297_b("Color", 3)) {
                return;
            }
            int color = messageCompound.func_74762_e("Color");
            if (messageCompound.func_150297_b("InputItem", 8)) {
                inputItemName = messageCompound.func_74779_i("Item");
            } else if (messageCompound.func_150297_b("InputItem", 10)) {
                itemCompound = messageCompound.func_74775_l("InputItem");
                stackFromCompound = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
                inputItemName = GameRegistry.findUniqueIdentifierFor((Item)stackFromCompound.func_77973_b()).toString();
            } else {
                return;
            }
            if (messageCompound.func_150297_b("JamItem", 8)) {
                jamItemName = messageCompound.func_74779_i("JamItem");
            } else if (messageCompound.func_150297_b("JamItem", 10)) {
                itemCompound = messageCompound.func_74775_l("ItemName");
                stackFromCompound = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
                jamItemName = GameRegistry.findUniqueIdentifierFor((Item)stackFromCompound.func_77973_b()).toString();
            } else {
                return;
            }
            float red = color >> 16 & 0xFF;
            float green = color >> 8 & 0xFF;
            float blue = color & 0xFF;
            Jam jam = new Jam(jamName, color, jamItemName);
            Jam.registerJam(jam);
            String ingredientName = inputItemName + "-" + "jam_" + jamName;
            Ingredient ingredient = new Ingredient(ingredientName, "ingredient.jam." + ingredientName + ".name", jamName);
            Ingredient.registerIngredient(ingredient);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ingredient.setRenderingHandler(new JamBaseRenderingHandler(new float[]{red * 255.0f, green * 255.0f, blue * 255.0f}));
            }
            KitchenItems.linkToIngredient(inputItemName, ingredientName);
        }
    }
}

