/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.CommonProxy;
import dk.mrspring.kitchen.IMCHandler;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.ModConfig;
import dk.mrspring.kitchen.ModLogger;
import dk.mrspring.kitchen.api.event.BoardEventRegistry;
import dk.mrspring.kitchen.block.BlockBase;
import dk.mrspring.kitchen.event.SandwichableTooltipEvent;
import dk.mrspring.kitchen.item.ItemBase;
import dk.mrspring.kitchen.pan.Ingredient;
import dk.mrspring.kitchen.pan.Jam;
import dk.mrspring.kitchen.recipe.OvenRecipes;
import dk.mrspring.kitchen.recipe.RecipeRegistry;
import dk.mrspring.kitchen.tileentity.TileEntityBoard;
import dk.mrspring.kitchen.tileentity.TileEntityKitchenCabinet;
import dk.mrspring.kitchen.tileentity.TileEntityOven;
import dk.mrspring.kitchen.tileentity.TileEntityPan;
import dk.mrspring.kitchen.tileentity.TileEntityPlate;
import dk.mrspring.kitchen.world.gen.WorldGenWildPlants;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="kitchen", name="Kitchen", version="1.3.23")
public class Kitchen {
    @Mod.Instance(value="kitchen")
    public static Kitchen instance;
    @SidedProxy(serverSide="dk.mrspring.kitchen.CommonProxy", clientSide="dk.mrspring.kitchen.ClientProxy")
    public static CommonProxy proxy;
    public CreativeTabs tab;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ModLogger.initializeLogger(event);
        ModConfig.load(event.getModConfigurationDirectory(), event.getSide());
        proxy.getConfigs();
        Kitchen.instance.tab = new CreativeTabs("tabKitchen"){

            public Item func_78016_d() {
                return KitchenItems.basic_sandwich.func_77973_b();
            }
        };
        GameRegistry.registerTileEntity(TileEntityBoard.class, (String)"tileEntityBoard");
        GameRegistry.registerTileEntity(TileEntityOven.class, (String)"tileEntityOven");
        GameRegistry.registerTileEntity(TileEntityPlate.class, (String)"tileEntityPlate");
        GameRegistry.registerTileEntity(TileEntityKitchenCabinet.class, (String)"tileEntityKitchenCabinet");
        GameRegistry.registerTileEntity(TileEntityPan.class, (String)"tileEntityFryingPan");
        ItemBase.load();
        BlockBase.load();
        BoardEventRegistry.registerDefaultEvents();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        ModLogger.print(0, "Loading Custom Oven recipes...");
        OvenRecipes.load();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWildPlants(), (int)1);
        RecipeRegistry.registerRecipes();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"dk.mrspring.kitchen.comp.waila.WailaDataProvider.callbackRegister");
        FMLInterModComms.sendRuntimeMessage((Object)"kitchen", (String)"VersionChecker", (String)"addVersionCheck", (String)"http://www.mrspring.dk/mods/kitchen/vchecker.json");
        FMLInterModComms.sendMessage((String)"cfm", (String)"register", (String)"dk.mrspring.kitchen.comp.furniture.CrayfishFurnitureRegister.registerRecipes");
        MinecraftForge.EVENT_BUS.register((Object)new SandwichableTooltipEvent());
        Jam.registerJam(new Jam("strawberry", 16196364, "kitchen:strawberry_jam"));
        Jam.registerJam(new Jam("apple", 14415786, "kitchen:apple_jam"));
        Jam.registerJam(new Jam("peanut", 9659689, "kitchen:peanut_jam"));
        Ingredient.registerIngredient(new Ingredient("strawberry", "jam.strawberry.name", "strawberry"));
        Ingredient.registerIngredient(new Ingredient("apple", "jam.apple.name", "apple"));
        Ingredient.registerIngredient(new Ingredient("peanut", "jam.peanut.name", "peanut"));
        Ingredient.registerIngredient(new Ingredient("bacon", "ingredient.bacon.name", new ItemStack(KitchenItems.bacon, 1)));
        Ingredient.registerIngredient(new Ingredient("chicken_fillet", "ingredient.chicken_fillet.name", KitchenItems.chicken_fillet));
        KitchenItems.linkToIngredient(KitchenItems.jammable_strawberry, "strawberry");
        KitchenItems.linkToIngredient(KitchenItems.cut_apple, "apple");
        KitchenItems.linkToIngredient(KitchenItems.raw_bacon, "bacon");
        KitchenItems.linkToIngredient(KitchenItems.peanut, "peanut");
        KitchenItems.linkToIngredient(KitchenItems.raw_chicken_fillet, "chicken_fillet");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        OvenRecipes.addFoodRecipes();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void interCommHandler(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message == null) continue;
            IMCHandler.handleMessage(message);
        }
    }
}

