/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.Kitchen;
import dk.mrspring.kitchen.KitchenBlocks;
import dk.mrspring.kitchen.ModInfo;
import dk.mrspring.kitchen.ModLogger;
import dk.mrspring.kitchen.item.ItemBase;
import dk.mrspring.kitchen.item.ItemJamJar;
import dk.mrspring.kitchen.item.ItemKnife;
import dk.mrspring.kitchen.item.ItemMandP;
import dk.mrspring.kitchen.item.ItemSandwich;
import dk.mrspring.kitchen.item.ItemSeedBase;
import dk.mrspring.kitchen.pan.Ingredient;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class KitchenItems {
    private static HashMap<String, String> ingredientRelations = new HashMap();
    public static final Item knife = new ItemKnife().func_77625_d(1);
    public static final Item mortar_and_pestle = new ItemMandP().func_77625_d(1);
    public static final Item mortar = new ItemBase("mortar", true);
    public static final Item pestle = new ItemBase("pestle", true);
    public static final Item raw_bacon = new ItemBase("bacon_raw", true);
    public static final Item bacon = new ItemBase("bacon_cooked", true);
    public static final Item bread_slice = new ItemBase("bread_slice", true);
    public static final Item toast = new ItemBase("toast", true);
    public static final Item tomato = new ItemSeedBase("tomato", KitchenBlocks.tomato_crop, true);
    public static final Item lettuce = new ItemSeedBase("lettuce", KitchenBlocks.lettuce_crop, true);
    public static final Item strawberry = new ItemSeedBase("strawberry", KitchenBlocks.strawberry_crop, true);
    public static final Item peanut = new ItemSeedBase("peanut", KitchenBlocks.peanut_crop, true);
    public static final Item peanuts_in_shell = new ItemBase("peanuts_in_shell", ModInfo.toTexture("peanuts"), true);
    public static final Item tomato_slice = new ItemBase("tomato_slice", true);
    public static final Item lettuce_leaf = new ItemBase("lettuce_leaf", true);
    public static final Item potato_slice = new ItemBase("potato_slice", true);
    public static final Item carrot_slice = new ItemBase("carrot_slice", true);
    public static final Item flour = new ItemBase("flour", true);
    public static final Item raw_roast_beef = new ItemBase("raw_roast_beef", "kitchen:beef_slice", true);
    public static final Item roast_beef = new ItemBase("roast_beef", true);
    public static final Item raw_chicken_fillet = new ItemBase("chicken_fillet_raw", true);
    public static final Item chicken_fillet = new ItemBase("chicken_fillet_cooked", true);
    public static final Item chicken_leg = new ItemFood(4, true).func_77655_b("chicken_leg").func_111206_d("kitchen:chicken_leg").func_77637_a(Kitchen.instance.tab);
    public static final Item cheese = new ItemFood(3, false).func_77655_b("cheese").func_111206_d("kitchen:cheese").func_77637_a(Kitchen.instance.tab);
    public static final Item cheese_slice = new ItemBase("cheese_slice", true);
    public static ItemStack basic_sandwich = KitchenItems.getSandwichItemStackWithNBTTags(new ItemStack[]{new ItemStack(bread_slice, 1, 0), new ItemStack(raw_bacon, 1, 0), new ItemStack(bread_slice, 1, 0)});
    public static final Item burnt_meat = new ItemFood(1, false).func_77655_b("burnt_meat").func_111206_d("kitchen:burnt_meat").func_77637_a(Kitchen.instance.tab);
    public static final Item butter = new ItemBase("butter", true);
    public static final Item jam_jar = new ItemJamJar("jam_jar");
    public static final Item jam_strawberry = new ItemBase("strawberry_jam", false).setLocalizableName("jam.strawberry.name");
    public static final Item jam_apple = new ItemBase("apple_jam", false).setLocalizableName("jam.apple.name");
    public static final Item jam_peanut = new ItemBase("peanut_jam", false).setLocalizableName("jam.peanut.name");
    public static final Item cut_strawberry = new ItemFood(1, false).func_111206_d(ModInfo.toTexture("strawberry_slices")).func_77655_b("strawberry_slices").func_77637_a(Kitchen.instance.tab);
    public static final Item jammable_strawberry = new ItemFood(1, false).func_111206_d(ModInfo.toTexture("strawberry_slices_sugared")).func_77655_b("sugared_strawberry_slices").func_77637_a(Kitchen.instance.tab);
    public static final Item cut_apple = new ItemFood(1, false).func_111206_d(ModInfo.toTexture("apple_slice")).func_77655_b("apple_slice").func_77637_a(Kitchen.instance.tab);

    private static ItemStack getSandwichItemStackWithNBTTags(ItemStack[] layers) {
        ItemSandwich sandwich = new ItemSandwich();
        GameRegistry.registerItem((Item)sandwich, (String)"sandwich");
        ItemStack basicSandwich = new ItemStack((Item)sandwich, 1, 0);
        NBTTagList layersList = new NBTTagList();
        for (ItemStack layer : layers) {
            NBTTagCompound layerCompound = new NBTTagCompound();
            layer.func_77955_b(layerCompound);
            layersList.func_74742_a((NBTBase)layerCompound);
        }
        basicSandwich.func_77983_a("SandwichLayers", (NBTBase)layersList);
        return basicSandwich;
    }

    public static void linkToIngredient(Item item, String ingredientName) {
        GameRegistry.UniqueIdentifier identifier;
        if (item != null && (identifier = GameRegistry.findUniqueIdentifierFor((Item)item)) != null) {
            KitchenItems.linkToIngredient(identifier.toString(), ingredientName);
        }
    }

    public static void linkToIngredient(String itemName, String ingredientName) {
        if (!ingredientRelations.containsKey(itemName)) {
            ModLogger.print(3, "Registering: " + itemName + " to ingredient: " + ingredientName);
            ingredientRelations.put(itemName, ingredientName);
        } else {
            ModLogger.print(3, "Tried to register: " + itemName + ", but it is already bound to: " + ingredientRelations.get(itemName));
        }
    }

    public static Ingredient valueOf(String itemName) {
        if (ingredientRelations.containsKey(itemName)) {
            return Ingredient.getIngredient(ingredientRelations.get(itemName));
        }
        return Ingredient.EMPTY;
    }

    public static Ingredient valueOf(Item item) {
        return KitchenItems.valueOf(GameRegistry.findUniqueIdentifierFor((Item)item).toString());
    }

    public static HashMap<String, String> getIngredientRelations() {
        return ingredientRelations;
    }
}

