/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.ModLogger;
import dk.mrspring.kitchen.config.BaseConfig;
import dk.mrspring.kitchen.config.ClientConfig;
import dk.mrspring.kitchen.config.KitchenConfig;
import dk.mrspring.kitchen.config.KnifeConfig;
import dk.mrspring.kitchen.config.OvenConfig;
import dk.mrspring.kitchen.config.SandwichableConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;

public class ModConfig {
    private static BaseConfig[] configs;

    public static void load(File baseFolder, Side side) {
        ArrayList<String> names = new ArrayList<String>();
        Collections.addAll(names, "Kitchen", "Knife", "Oven", "Sandwichable");
        if (side.isClient()) {
            names.add("Client");
        }
        configs = new BaseConfig[names.size()];
        File configFolder = new File(baseFolder, "TheKitchenMod");
        for (int i = 0; i < configs.length; ++i) {
            try {
                String name = (String)names.get(i);
                Class<?> configClass = Class.forName("dk.mrspring.kitchen.config." + name + "Config");
                File configFile = new File(configFolder, name + ".json");
                ModLogger.print(0, "Loading " + name + " config from JSON at " + configFile.getPath());
                BaseConfig config = (BaseConfig)configClass.getConstructor(File.class, String.class).newInstance(configFile, name);
                ModConfig.configs[i] = config.readFromFile();
                configs[i].writeToFile();
                configs[i].addDefaults();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static KitchenConfig getKitchenConfig() {
        return (KitchenConfig)configs[0];
    }

    public static KnifeConfig getKnifeConfig() {
        return (KnifeConfig)configs[1];
    }

    public static OvenConfig getOvenConfig() {
        return (OvenConfig)configs[2];
    }

    public static SandwichableConfig getSandwichConfig() {
        return (SandwichableConfig)configs[3];
    }

    @SideOnly(value=Side.CLIENT)
    public static ClientConfig getClientConfig() {
        return (ClientConfig)configs[configs.length - 1];
    }
}

