/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.api.event;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.api.event.IBoardEvent;
import dk.mrspring.kitchen.api.event.IOnAddedToBoardEvent;
import dk.mrspring.kitchen.api.event.IOnBoardRightClickedEvent;
import dk.mrspring.kitchen.api.event.ITopItemEvent;
import dk.mrspring.kitchen.pan.Jam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BoardEventRegistry {
    static Map<String, IBoardEvent> onAddedToBoardEvents = new HashMap<String, IBoardEvent>();
    static Map<String, IBoardEvent> onBoardRightClickedEvents = new HashMap<String, IBoardEvent>();
    static Map<String, IBoardEvent> topItemEvents = new HashMap<String, IBoardEvent>();
    static IOnAddedToBoardEvent defaultOnAddedToBoardEvent = new IOnAddedToBoardEvent(){

        @Override
        public void onAdded(List<ItemStack> layers, ItemStack added, NBTTagCompound specialTagInfo) {
        }

        @Override
        public boolean canAdd(List<ItemStack> currentLayers, ItemStack toAdd, NBTTagCompound specialTagInfo) {
            return true;
        }

        @Override
        public ItemStack addedToBoard(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
            return added.func_77946_l();
        }

        @Override
        public boolean decrementStackSize(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
            return true;
        }

        @Override
        public String getEventName() {
            return "on_added-default";
        }
    };
    static IOnBoardRightClickedEvent defaultOnBoardRightClickedEvent = new IOnBoardRightClickedEvent(){

        @Override
        public void onRightClicked(List<ItemStack> layers, ItemStack rightClicked, NBTTagCompound specialTagInfo) {
        }

        @Override
        public String getEventName() {
            return "on_right_click-default";
        }
    };
    static ITopItemEvent defaultTopItemEvent = new ITopItemEvent(){

        @Override
        public boolean canAddItemOnTop(List<ItemStack> layers, ItemStack tryingToAdd, NBTTagCompound specialTagInfo) {
            return true;
        }

        @Override
        public ItemStack getDroppeditem(List<ItemStack> layers, ItemStack removed, NBTTagCompound specialTagInfo) {
            return removed;
        }

        @Override
        public String getEventName() {
            return "top_item-default";
        }
    };

    public static void registerTopItemEvent(String itemName, IBoardEvent event) {
        if (itemName != null && !topItemEvents.containsKey(itemName)) {
            topItemEvents.put(itemName, event);
        }
    }

    public static void registerTopItemEvent(Item item, IBoardEvent event) {
        BoardEventRegistry.registerTopItemEvent(GameRegistry.findUniqueIdentifierFor((Item)item).toString(), event);
    }

    public static void registerTopItemEvent(Block block, IBoardEvent event) {
        BoardEventRegistry.registerTopItemEvent(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), event);
    }

    public static void registerOnRightClickedEvent(String itemName, IBoardEvent event) {
        if (itemName != null && !onBoardRightClickedEvents.containsKey(itemName)) {
            onBoardRightClickedEvents.put(itemName, event);
        }
    }

    public static void registerOnRightClickedEvent(Item item, IBoardEvent event) {
        BoardEventRegistry.registerOnRightClickedEvent(GameRegistry.findUniqueIdentifierFor((Item)item).toString(), event);
    }

    public static void registerOnRightClickedEvent(Block block, IBoardEvent event) {
        BoardEventRegistry.registerOnRightClickedEvent(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), event);
    }

    public static void registerOnAddedEvent(String itemName, IBoardEvent event) {
        if (itemName != null && !onAddedToBoardEvents.containsKey(itemName)) {
            onAddedToBoardEvents.put(itemName, event);
        }
    }

    public static void registerOnAddedEvent(Item item, IBoardEvent event) {
        BoardEventRegistry.registerOnAddedEvent(GameRegistry.findUniqueIdentifierFor((Item)item).toString(), event);
    }

    public static void registerOnAddedEvent(Block block, IBoardEvent event) {
        BoardEventRegistry.registerOnAddedEvent(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), event);
    }

    public static IBoardEvent getOnAddedToBoardEventFor(String itemName) {
        if (onAddedToBoardEvents.containsKey(itemName)) {
            return onAddedToBoardEvents.get(itemName);
        }
        return BoardEventRegistry.getDefaultOnAddedToBoardEvent();
    }

    public static IBoardEvent getOnAddedToBoardEventFor(Item item) {
        return BoardEventRegistry.getOnAddedToBoardEventFor(GameRegistry.findUniqueIdentifierFor((Item)item).toString());
    }

    public static IBoardEvent getOnBoardRightClickedEventFor(String itemName) {
        if (onBoardRightClickedEvents.containsKey(itemName)) {
            return onBoardRightClickedEvents.get(itemName);
        }
        return BoardEventRegistry.getDefaultOnBoardRightClickedEvent();
    }

    public static IBoardEvent getOnBoardRightClickedEventFor(Item item) {
        return BoardEventRegistry.getOnBoardRightClickedEventFor(GameRegistry.findUniqueIdentifierFor((Item)item).toString());
    }

    public static IBoardEvent getTopItemEventFor(String itemName) {
        if (topItemEvents.containsKey(itemName)) {
            return topItemEvents.get(itemName);
        }
        return BoardEventRegistry.getDefaultTopItemEvent();
    }

    public static IBoardEvent getTopItemEventFor(Item item) {
        return BoardEventRegistry.getTopItemEventFor(GameRegistry.findUniqueIdentifierFor((Item)item).toString());
    }

    public static IBoardEvent getTopItemEventFor(ItemStack stack) {
        if (stack != null) {
            return BoardEventRegistry.getTopItemEventFor(stack.func_77973_b());
        }
        return BoardEventRegistry.getDefaultTopItemEvent();
    }

    public static IOnAddedToBoardEvent getDefaultOnAddedToBoardEvent() {
        return defaultOnAddedToBoardEvent;
    }

    public static IOnBoardRightClickedEvent getDefaultOnBoardRightClickedEvent() {
        return defaultOnBoardRightClickedEvent;
    }

    public static ITopItemEvent getDefaultTopItemEvent() {
        return defaultTopItemEvent;
    }

    public static void registerDefaultEvents() {
        BoardEventRegistry.registerOnAddedEvent(KitchenItems.butter, (IBoardEvent)new IOnAddedToBoardEvent(){

            @Override
            public void onAdded(List<ItemStack> layers, ItemStack added, NBTTagCompound specialTagInfo) {
                specialTagInfo.func_74768_a("ClickAmount", 2);
            }

            @Override
            public boolean canAdd(List<ItemStack> currentLayers, ItemStack toAdd, NBTTagCompound specialTagInfo) {
                return currentLayers.size() > 0 && currentLayers.get(currentLayers.size() - 1).func_77973_b() == KitchenItems.bread_slice;
            }

            @Override
            public ItemStack addedToBoard(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
                return added.func_77946_l();
            }

            @Override
            public boolean decrementStackSize(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
                return true;
            }

            @Override
            public String getEventName() {
                return "on_added-kitchen:butter";
            }
        });
        BoardEventRegistry.registerTopItemEvent(KitchenItems.butter, (IBoardEvent)new ITopItemEvent(){

            @Override
            public boolean canAddItemOnTop(List<ItemStack> layers, ItemStack tryingToAdd, NBTTagCompound specialTagInfo) {
                return specialTagInfo.func_74762_e("ClickAmount") <= 0;
            }

            @Override
            public ItemStack getDroppeditem(List<ItemStack> layers, ItemStack removed, NBTTagCompound specialTagInfo) {
                if (specialTagInfo.func_74762_e("ClickAmount") == 2) {
                    return removed;
                }
                return null;
            }

            @Override
            public String getEventName() {
                return "top_item-kitchen:butter";
            }
        });
        BoardEventRegistry.registerOnRightClickedEvent(KitchenItems.knife, (IBoardEvent)new IOnBoardRightClickedEvent(){

            @Override
            public void onRightClicked(List<ItemStack> layers, ItemStack rightClicked, NBTTagCompound specialTagInfo) {
                if (layers.size() > 0 && layers.get(layers.size() - 1).func_77973_b() == KitchenItems.butter && specialTagInfo.func_74764_b("ClickAmount")) {
                    specialTagInfo.func_74768_a("ClickAmount", specialTagInfo.func_74762_e("ClickAmount") - 1);
                }
            }

            @Override
            public String getEventName() {
                return "on_right_clicked-kitchen:butter_knife";
            }
        });
        BoardEventRegistry.registerOnAddedEvent(KitchenItems.jam_jar, (IBoardEvent)new IOnAddedToBoardEvent(){

            @Override
            public void onAdded(List<ItemStack> layers, ItemStack added, NBTTagCompound specialTagInfo) {
                NBTTagCompound jamInfo;
                if (added.func_77978_p() != null && (jamInfo = added.func_77978_p().func_74775_l("JamInfo")) != null) {
                    int usesLeft = jamInfo.func_74762_e("UsesLeft");
                    if (--usesLeft == 0) {
                        added.func_77964_b(0);
                    }
                    jamInfo.func_74768_a("UsesLeft", usesLeft);
                    added.func_77983_a("JamInfo", (NBTBase)jamInfo);
                }
            }

            @Override
            public boolean canAdd(List<ItemStack> currentLayers, ItemStack toAdd, NBTTagCompound specialTagInfo) {
                if (toAdd.func_77978_p() != null) {
                    NBTTagCompound jamInfo = toAdd.func_77978_p().func_74775_l("JamInfo");
                    if (jamInfo != null) {
                        int usesLeft = jamInfo.func_74762_e("UsesLeft");
                        Jam jam = Jam.getJam(jamInfo.func_74779_i("JamType"));
                        return jam != Jam.getJam("empty") && usesLeft != 0;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public ItemStack addedToBoard(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
                Jam jam;
                NBTTagCompound jamInfo;
                if (added.func_77978_p() != null && (jamInfo = added.func_77978_p().func_74775_l("JamInfo")) != null && (jam = Jam.getJam(jamInfo.func_74779_i("JamType"))) != Jam.getJam("empty")) {
                    return new ItemStack(jam.getItem(), 1);
                }
                return null;
            }

            @Override
            public boolean decrementStackSize(List<ItemStack> currentLayers, ItemStack added, NBTTagCompound specialTagInfo) {
                return false;
            }

            @Override
            public String getEventName() {
                return "on_added-kitchen:jam_jar";
            }
        });
    }
}

