/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.api.sandwichable;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.api.sandwichable.ISandwichableRenderingHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SandwichableRenderingRegistry {
    static Map<String, ISandwichableRenderingHandler> renderers = new HashMap<String, ISandwichableRenderingHandler>();
    private static final ISandwichableRenderingHandler FALLBACK_HANDLER = new ISandwichableRenderingHandler(){

        @Override
        public ModelBase getModel(ItemStack[] itemStacks, int indexInList, NBTTagCompound specialTagInfo) {
            return null;
        }

        @Override
        public double getModelHeight(ItemStack[] itemStacks, int indexInList, NBTTagCompound specialTagInfo) {
            return 0.03125;
        }
    };

    public static ISandwichableRenderingHandler getRenderingHandlerFor(String itemName) {
        if (renderers.containsKey(itemName)) {
            return renderers.get(itemName);
        }
        return FALLBACK_HANDLER;
    }

    public static ISandwichableRenderingHandler getRenderingHandlerFor(ItemStack item) {
        String key = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b()).toString();
        return SandwichableRenderingRegistry.getRenderingHandlerFor(key);
    }

    public static void registerRenderingHandler(String itemName, ISandwichableRenderingHandler renderingHandler) {
        if (!renderers.containsKey(itemName)) {
            renderers.put(itemName, renderingHandler);
        }
    }

    public static void registerRenderingHandler(Item item, ISandwichableRenderingHandler renderingHandler) {
        SandwichableRenderingRegistry.registerRenderingHandler(GameRegistry.findUniqueIdentifierFor((Item)item).toString(), renderingHandler);
    }

    public static void registerRenderingHandler(Block block, ISandwichableRenderingHandler renderingHandler) {
        SandwichableRenderingRegistry.registerRenderingHandler(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), renderingHandler);
    }
}

