/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.client.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientUtils {
    public static void push() {
        GL11.glPushMatrix();
    }

    public static void pop() {
        GL11.glPopMatrix();
    }

    public static void bind(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static void translate(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void rotate(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void rotate(int angle) {
        ClientUtils.rotate(4, angle);
    }

    public static void rotate(int angles, int angle) {
        float degrees = (float)angle / (float)angles;
        ClientUtils.rotate(360.0f * degrees, 0.0f, 1.0f, 0.0f);
    }

    public static void scale(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void scale(float scale) {
        ClientUtils.scale(scale, scale, scale);
    }

    public static ResourceLocation modelTexture(String name) {
        return ModInfo.toLocation(String.format("textures/models/%s.png", name));
    }

    public static void enableTextures() {
        GL11.glEnable((int)3553);
    }

    public static float fromDegrees(float degrees) {
        return (float)Math.toRadians(degrees);
    }
}

