/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.common.api.oven.item;

import dk.mrspring.kitchen.Kitchen;
import dk.mrspring.kitchen.common.api.oven.item.OvenItem;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class OvenItemStack {
    private static final String OVEN_ITEM_ID = "OIId";
    private static final String COMPOUND_INFO = "CompoundInfo";
    OvenItem item;
    String name;
    public NBTTagCompound compound;

    public OvenItemStack(OvenItem item) {
        this(item, (String)Kitchen.ovenItems.reverseGet(item));
    }

    public OvenItemStack(String name) {
        this((OvenItem)Kitchen.ovenItems.get(name), name);
    }

    public OvenItemStack(OvenItem item, String name) {
        this.setItem(item, name);
    }

    public boolean hasCompound() {
        return this.compound == null;
    }

    public NBTTagCompound getCompound() {
        if (this.compound == null) {
            this.setCompound(new NBTTagCompound());
        }
        return this.compound;
    }

    public void setCompound(NBTTagCompound compound) {
        this.compound = compound;
    }

    public void setItem(OvenItem item, String name) {
        this.item = item;
        this.name = name;
    }

    public OvenItemStack copy() {
        OvenItemStack stack = new OvenItemStack(this.item, this.name);
        stack.setCompound(this.compound);
        return stack;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a(OVEN_ITEM_ID, this.name);
        if (this.compound != null) {
            System.out.println("Setting compound");
            compound.func_74782_a(COMPOUND_INFO, (NBTBase)this.compound);
        }
    }

    public static OvenItemStack fromNBT(NBTTagCompound compound) {
        String id = compound.func_74779_i(OVEN_ITEM_ID);
        OvenItem item = (OvenItem)Kitchen.ovenItems.get(id);
        if (item != null) {
            OvenItemStack stack = new OvenItemStack(item, id);
            if (compound.func_150297_b(COMPOUND_INFO, 10)) {
                stack.setCompound(compound.func_74775_l(COMPOUND_INFO));
            }
            return stack;
        }
        return null;
    }

    public OvenItem getItem() {
        return this.item;
    }
}

