/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.common.api.recipe;

import com.google.common.collect.Lists;
import dk.mrspring.kitchen.common.api.recipe.IRecipe;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeHandler {
    List<IRecipe> recipes = Lists.newLinkedList();

    public RecipeHandler(IRecipe ... recipes) {
        Collections.addAll(this.recipes, recipes);
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(0, recipe);
    }

    public IRecipe getRecipe(ItemStack input) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.acceptsInput(input)) continue;
            return recipe;
        }
        return null;
    }

    public ItemStack[] getOutput(ItemStack input) {
        IRecipe recipe = this.getRecipe(input);
        if (recipe != null) {
            return recipe.getOutput(input);
        }
        return new ItemStack[0];
    }

    public boolean hasOutput(ItemStack input) {
        return this.getOutput(input).length > 0;
    }
}

