/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.common.api.registry;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class RegistryBase<K, V> {
    Map<K, V> registered = Maps.newHashMap();
    V valueFallback = null;
    K keyFallback = null;

    public V get(K key) {
        if (key == null) {
            return this.getValueFallback(null);
        }
        return this.registered.getOrDefault(key, this.getValueFallback(key));
    }

    public K reverseGet(V value) {
        for (Map.Entry<K, V> entry : this.registered.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return this.getKeyFallback(value);
    }

    public boolean register(K key, V registering) {
        if (!this.registered.containsKey(key)) {
            this.registered.put(key, registering);
            return true;
        }
        System.err.println("Tried to register: \"" + key + "\", in: \"" + this.getClass().getName() + "\", but there is already an item registered with that key!");
        return false;
    }

    public Collection<V> getRegisteredItems() {
        return this.registered.values();
    }

    public V getValueFallback(K key) {
        return this.valueFallback;
    }

    public K getKeyFallback(V value) {
        return this.keyFallback;
    }
}

