/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.common.item;

import dk.mrspring.kitchen.common.item.IComparable;
import dk.mrspring.kitchen.common.item.ItemNoLogic;
import dk.mrspring.kitchen.common.util.ItemUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemContainerBase
extends ItemNoLogic
implements IComparable {
    public final String TYPE_TAG;
    public String containsKey = null;
    public String typeFormat = null;

    public ItemContainerBase(String typeTag, String name, String textureName, CreativeTabs tab) {
        super(name, textureName, tab);
        this.TYPE_TAG = typeTag;
    }

    public ItemContainerBase(String typeTag, String name, CreativeTabs tab) {
        super(name, tab);
        this.TYPE_TAG = typeTag;
    }

    public ItemContainerBase(String typeTag, String name) {
        super(name);
        this.TYPE_TAG = typeTag;
    }

    public ItemContainerBase setContainsFormat(String containsKey, String typeFormat) {
        this.containsKey = containsKey;
        this.typeFormat = typeFormat;
        return this;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        String contains;
        super.func_77624_a(stack, player, list, flag);
        if (this.containsKey != null && ItemUtils.damage(stack) > 0 && ItemUtils.hasString(stack, this.TYPE_TAG) && (contains = this.getTypeForDisplay(stack)) != null) {
            list.add(I18n.func_135052_a((String)this.containsKey, (Object[])new Object[]{contains}));
        }
    }

    public String getType(ItemStack stack) {
        return ItemUtils.getString(stack, this.TYPE_TAG);
    }

    public String getTypeForDisplay(ItemStack stack) {
        String type = this.getType(stack);
        return type == null ? null : I18n.func_135052_a((String)String.format(this.typeFormat, type), (Object[])new Object[0]);
    }

    @Override
    public boolean compareStacks(ItemStack stack1, ItemStack stack2) {
        return ItemUtils.areContainerStacksEqual(stack1, stack2, this, this.TYPE_TAG);
    }
}

