/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.common.util;

import dk.mrspring.kitchen.Kitchen;
import dk.mrspring.kitchen.common.item.IComparable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ItemUtils {
    public static final int END = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int BYTE_ARRAY = 7;
    public static final int STRING = 8;
    public static final int LIST = 9;
    public static final int COMPOUND = 10;
    public static final int INT_ARRAY = 11;

    public static boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() instanceof IComparable) {
            return ((IComparable)stack1.func_77973_b()).compareStacks(stack1, stack2);
        }
        if (stack2.func_77973_b() instanceof IComparable) {
            return ((IComparable)stack2.func_77973_b()).compareStacks(stack2, stack1);
        }
        return ItemUtils.item(stack1, stack2) && ItemUtils.equalDamage(stack1, stack2) && ItemUtils.equalTags(stack1, stack2);
    }

    public static boolean notEmpty(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && stack.field_77994_a > 0;
    }

    public static boolean areContainerStacksEqual(ItemStack stack1, ItemStack stack2, Item item, String tag) {
        if (!ItemUtils.items(item, stack1, stack2)) {
            return false;
        }
        String type1 = ItemUtils.getString(stack1, tag);
        String type2 = ItemUtils.getString(stack2, tag);
        return type1 != null && type2 != null && type1.equals(type2);
    }

    public static boolean equalDamage(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static boolean equalTags(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77942_o() && stack2.func_77942_o()) {
            return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
        }
        return !stack1.func_77942_o() && !stack2.func_77942_o();
    }

    public static boolean item(ItemStack stack, Block block) {
        return ItemUtils.item(stack, ItemBlock.func_150898_a((Block)block));
    }

    public static boolean item(ItemStack stack, Item item) {
        return stack != null && stack.func_77973_b() == item;
    }

    public static boolean item(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b();
    }

    public static boolean items(Item item, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (ItemUtils.item(stack, item)) continue;
            return false;
        }
        return true;
    }

    public static boolean itemDict(ItemStack stack, String oreDictionaryName) {
        if (stack != null) {
            int[] idsForStack = OreDictionary.getOreIDs((ItemStack)stack);
            int idForName = OreDictionary.getOreID((String)oreDictionaryName);
            return ArrayUtils.contains((int[])idsForStack, (int)idForName);
        }
        return oreDictionaryName == null;
    }

    public static boolean canDrop(ItemStack stack) {
        if (ItemUtils.item(stack, Kitchen.items.mixing_bowl)) {
            return false;
        }
        return !ItemUtils.item(stack, Kitchen.items.jam_jar);
    }

    public static String name(ItemStack stack, String fallback) {
        return stack != null ? stack.toString() : fallback;
    }

    public static String name(ItemStack stack) {
        return ItemUtils.name(stack, "null");
    }

    public static void decrDamage(ItemStack stack, int amount) {
        ItemUtils.incrDamage(stack, -amount);
    }

    public static void incrDamage(ItemStack stack, int amount) {
        ItemUtils.setDamage(stack, ItemUtils.damage(stack) + amount);
    }

    public static int damage(ItemStack stack, int amount, int min) {
        return ItemUtils.damage(stack, Math.min(amount, ItemUtils.damage(stack) - min));
    }

    public static int damage(ItemStack stack, int amount) {
        ItemUtils.decrDamage(stack, amount);
        return ItemUtils.damage(stack);
    }

    public static int damage(ItemStack stack) {
        return stack.func_77960_j();
    }

    public static void setDamage(ItemStack stack, int newDamage) {
        stack.func_77964_b(newDamage);
    }

    public static void decrSize(ItemStack stack, int amount) {
        ItemUtils.incrSize(stack, -amount);
    }

    public static void incrSize(ItemStack stack, int amount) {
        ItemUtils.setSize(stack, ItemUtils.size(stack) + amount);
    }

    public static int size(ItemStack stack, int amount, int min) {
        return ItemUtils.damage(stack, Math.min(amount, ItemUtils.size(stack) - min));
    }

    public static int size(ItemStack stack, int amount) {
        ItemUtils.decrSize(stack, amount);
        return ItemUtils.size(stack);
    }

    public static int size(ItemStack stack) {
        return stack.field_77994_a;
    }

    public static void setSize(ItemStack stack, int newSize) {
        stack.field_77994_a = Math.max(0, newSize);
    }

    public static ItemStack fromNBT(NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)compound);
    }

    public static NBTTagCompound toNBT(ItemStack stack) {
        return stack.func_77955_b(new NBTTagCompound());
    }

    public static ItemStack copy(ItemStack stack, int newStackSize, int newDamage) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = newStackSize;
        ItemUtils.setDamage(stack, newDamage);
        return copy;
    }

    public static ItemStack copy(ItemStack stack, int newStackSize) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = newStackSize;
        return copy;
    }

    public static ItemStack copy(ItemStack stack) {
        return stack.func_77946_l();
    }

    public static String getString(ItemStack stack, String name) {
        return ItemUtils.getCompound(stack).func_74779_i(name);
    }

    public static void setString(ItemStack stack, String name, String value) {
        ItemUtils.getCompound(stack).func_74778_a(name, value);
    }

    public static boolean hasString(ItemStack stack, String name) {
        return ItemUtils.getCompound(stack).func_150297_b(name, 8);
    }

    public static NBTTagCompound getCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(ItemUtils.newCompound());
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound getCompound(ItemStack stack, String name) {
        NBTTagCompound compound = ItemUtils.getCompound(stack);
        if (!compound.func_150297_b(name, 10)) {
            compound.func_74782_a(name, (NBTBase)ItemUtils.newCompound());
        }
        return compound.func_74775_l(name);
    }

    public static void removeTag(ItemStack stack, String name) {
        ItemUtils.getCompound(stack).func_82580_o(name);
    }

    private static NBTTagCompound newCompound() {
        return new NBTTagCompound();
    }

    public static ItemStack newStack(Item item, int size, int damage) {
        return new ItemStack(item, size, damage);
    }

    public static ItemStack newStack(Item item, int size) {
        return ItemUtils.newStack(item, size, 0);
    }

    public static ItemStack newStack(Item item) {
        return ItemUtils.newStack(item, 1);
    }

    public static ItemStack newStack(Block block, int size, int damage) {
        return new ItemStack(block, size, damage);
    }

    public static ItemStack newStack(Block block, int size) {
        return ItemUtils.newStack(block, size, 0);
    }

    public static ItemStack newStack(Block block) {
        return ItemUtils.newStack(block, 1);
    }
}

