/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class BaseConfig {
    private File location;
    private String label;

    public BaseConfig() {
    }

    public BaseConfig(File location, String name) {
        this();
        this.setLocation(location);
        this.setLabel(name);
    }

    public BaseConfig readFromFile() throws IOException {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        Gson gson = builder.create();
        if (this.location.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(this.location));
            BaseConfig config = (BaseConfig)gson.fromJson((Reader)reader, this.getClass());
            config.setLocation(this.location);
            config.setLabel(this.getLabel());
            return config;
        }
        this.location.getParentFile().mkdir();
        this.location.createNewFile();
        this.writeToFile();
        return this;
    }

    public void writeToFile() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.location));
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.hasModifier(2);
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }});
        Gson gson = builder.create();
        String json = gson.toJson((Object)this);
        this.location.createNewFile();
        FileWriter writer = new FileWriter(this.location);
        writer.write(json);
        writer.close();
    }

    public BaseConfig setLocation(File location) {
        this.location = location;
        return this;
    }

    public File getLocation() {
        return this.location;
    }

    public BaseConfig setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void addDefaults() {
    }
}

