/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.item;

import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.item.ItemBase;
import dk.mrspring.kitchen.pan.Jam;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemJamJar
extends ItemBase {
    IIcon[] jamIcon = new IIcon[6];

    public ItemJamJar(String name) {
        super(name, true);
        this.func_77625_d(1);
    }

    public static ItemStack getJamJarItemStack(String jam, int usesLeft) {
        return ItemJamJar.getJamJarItemStack(Jam.getJam(jam), usesLeft);
    }

    public static ItemStack getJamJarItemStack(Jam jam, int usesLeft) {
        ItemStack jamStack = new ItemStack(KitchenItems.jam_jar, 1, 1);
        if (jam == Jam.EMPTY) {
            jamStack.func_77964_b(0);
            return jamStack;
        }
        String jamName = jam.getName();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("JamType", jamName);
        compound.func_74768_a("UsesLeft", usesLeft);
        jamStack.func_77983_a("JamInfo", (NBTBase)compound);
        return jamStack;
    }

    public static boolean isJar(ItemStack stack) {
        return stack != null && stack.func_77973_b() == KitchenItems.jam_jar;
    }

    public static boolean isEmptyJar(ItemStack stack) {
        return ItemJamJar.isJar(stack) && ItemJamJar.getJam(stack) == Jam.EMPTY;
    }

    public static Jam getJam(ItemStack stack) {
        String type;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("JamInfo", 10) && (type = stack.func_77978_p().func_74775_l("JamInfo").func_74779_i("JamType")) != null && type.isEmpty()) {
            return Jam.getJam(type);
        }
        return Jam.EMPTY;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        if (metadata == 0) {
            return 1;
        }
        return 2;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int usesLeft;
        NBTTagCompound jamInfo;
        if (pass == 1 || stack.func_77960_j() == 0) {
            return super.getIcon(stack, pass);
        }
        if (stack.field_77990_d != null && (jamInfo = stack.field_77990_d.func_74775_l("JamInfo")) != null && (usesLeft = jamInfo.func_74762_e("UsesLeft")) != 0) {
            return this.jamIcon[usesLeft - 1];
        }
        return super.getIcon(stack, pass);
    }

    @Override
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int usesLeft;
        NBTTagCompound jamInfo;
        if (par1ItemStack.field_77990_d != null && par1ItemStack.func_77960_j() != 0 && (jamInfo = par1ItemStack.field_77990_d.func_74775_l("JamInfo")) != null && (usesLeft = jamInfo.func_74762_e("UsesLeft")) != 0) {
            par3List.add(StatCollector.func_74838_a((String)"item.jam_jar.uses_left_msg") + ": " + usesLeft);
        }
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par2 == 0 && par1ItemStack.func_77960_j() != 0) {
            NBTTagCompound jamInfo;
            Jam jam = Jam.getJam("empty");
            if (par1ItemStack.field_77990_d != null && (jamInfo = par1ItemStack.field_77990_d.func_74775_l("JamInfo")) != null) {
                jam = Jam.getJam(jamInfo.func_74779_i("JamType"));
            }
            return jam.getColor();
        }
        return super.func_82790_a(par1ItemStack, par2);
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        for (int i = 0; i < this.jamIcon.length; ++i) {
            this.jamIcon[i] = par1IconRegister.func_94245_a("kitchen:jam_jar_filling_" + (i + 1));
        }
    }

    @Override
    public String func_77653_i(ItemStack par1ItemStack) {
        NBTTagCompound jamInfo;
        NBTTagCompound compound;
        if (par1ItemStack.func_77960_j() != 0 && (compound = par1ItemStack.func_77978_p()) != null && (jamInfo = compound.func_74775_l("JamInfo")) != null) {
            Jam jam = Jam.getJam(jamInfo.func_74779_i("JamType"));
            return StatCollector.func_74838_a((String)("jam." + jam.getName().toLowerCase() + ".name")) + " " + StatCollector.func_74838_a((String)"item.jam_jar.filled.name");
        }
        return StatCollector.func_74838_a((String)"item.jam_jar.empty.name");
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return false;
    }
}

