/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.item.render;

import dk.mrspring.kitchen.ClientUtils;
import dk.mrspring.kitchen.config.ClientConfig;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public abstract class ItemRenderer
implements IItemRenderer {
    boolean isBlock = false;
    boolean animateDropped = true;

    public ItemRenderer renderLikeBlock() {
        this.isBlock = true;
        return this;
    }

    public ItemRenderer disableDroppedAnimation() {
        this.animateDropped = false;
        return this;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return this.getRenderConfig().handleType(type);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_ROTATION: 
            case ENTITY_BOBBING: {
                return this.animateDropped;
            }
            case INVENTORY_BLOCK: 
            case BLOCK_3D: 
            case EQUIPPED_BLOCK: {
                return this.isBlock;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        ClientUtils.push();
        switch (type) {
            case ENTITY: {
                this.renderEntity(type, item, data);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(type, item, data);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedFirstPerson(type, item, data);
                break;
            }
            case INVENTORY: {
                this.renderInventory(type, item, data);
            }
        }
        this.renderAnyTypes(item, data);
        ClientUtils.pop();
    }

    public void renderEntity(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (this.isBlock) {
            this.translateEntityBlock(stack, data);
        }
    }

    public void translateEntityBlock(ItemStack stack, Object ... data) {
        ClientUtils.translate(0.0f, 1.0f, 0.0f);
        ClientUtils.rotate(180.0f, 1.0f, 0.0f, 0.0f);
    }

    public void renderEquipped(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (this.isBlock) {
            this.translateBlock(type, stack, data);
        }
    }

    public void renderEquippedFirstPerson(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (this.isBlock) {
            this.translateBlock(type, stack, data);
        }
    }

    public void translateBlock(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        ClientUtils.translate(0.5f, 1.5f, 0.5f);
        ClientUtils.rotate(180.0f, 1.0f, 0.0f, 0.0f);
    }

    public void renderInventory(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (this.isBlock) {
            this.translateInventoryBlock(stack, data);
        }
    }

    public void translateInventoryBlock(ItemStack stack, Object ... data) {
        ClientUtils.rotate(180.0f, 1.0f, 0.0f, 0.0f);
        ClientUtils.translate(0.0f, -1.0f, 0.0f);
    }

    public void centerRotate(float angle, float x, float y, float z) {
        ClientUtils.translate(0.5f, 0.5f, 0.5f);
        ClientUtils.rotate(angle, x, y, z);
        ClientUtils.translate(-0.5f, -0.5f, -0.5f);
    }

    public void centerScale(float scale) {
        ClientUtils.translate(0.5f, 0.0f, 0.5f);
        ClientUtils.scale(scale);
        ClientUtils.translate(-0.5f, 0.0f, -0.5f);
    }

    public abstract void renderAnyTypes(ItemStack var1, Object ... var2);

    public abstract ClientConfig.RenderConfig getRenderConfig();
}

