/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.item.render;

import dk.mrspring.kitchen.ClientUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlateRender {
    public static final String IS_RENDERING_ON_PLATE = "IsRenderingOnPlate";
    public static final String PLATE_ITEM_HEIGHT = "PlateItemHeight";

    public static double renderPlateContents(Plate plate) {
        ItemStack[] stacks = plate.items;
        double yOffset = 0.0;
        for (ItemStack stack : stacks) {
            ClientUtils.push();
            ClientUtils.translate(0.0, yOffset, 0.0);
            yOffset += PlateRender.renderItem(stack);
            ClientUtils.pop();
        }
        return yOffset;
    }

    private static double renderItem(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a(IS_RENDERING_ON_PLATE, true);
        }
        ClientUtils.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        ClientUtils.push();
        ClientUtils.renderItemStack(stack);
        ClientUtils.pop();
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(IS_RENDERING_ON_PLATE);
            if (stack.func_77978_p().func_150297_b(PLATE_ITEM_HEIGHT, 6)) {
                return stack.func_77978_p().func_74769_h(PLATE_ITEM_HEIGHT);
            }
        }
        return 0.03125;
    }

    public static class Plate {
        ItemStack[] items;

        public Plate(ItemStack stack) {
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("PlateData", 10)) {
                NBTTagCompound info = stack.func_77978_p().func_74775_l("PlateData");
                NBTTagList list = info.func_150295_c("Items", 10);
                if (list.func_74745_c() > 0) {
                    this.items = new ItemStack[list.func_74745_c()];
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        this.items[i] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                    }
                } else {
                    this.items = new ItemStack[0];
                }
            } else {
                this.items = new ItemStack[0];
            }
        }

        public Plate(List<ItemStack> items) {
            this.items = items.toArray(new ItemStack[items.size()]);
        }
    }
}

