/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.item.render;

import dk.mrspring.kitchen.ClientUtils;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.api.sandwichable.ISandwichableRenderingHandler;
import dk.mrspring.kitchen.api.sandwichable.SandwichableRenderingRegistry;
import dk.mrspring.kitchen.model.ModelBaconCooked;
import dk.mrspring.kitchen.model.ModelBaconRaw;
import dk.mrspring.kitchen.model.ModelBreadSliceBottom;
import dk.mrspring.kitchen.model.ModelBreadSliceTop;
import dk.mrspring.kitchen.model.butter.ModelButter0;
import dk.mrspring.kitchen.model.butter.ModelButter1;
import dk.mrspring.kitchen.model.butter.ModelButter2;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SandwichRender {
    public static final String IS_RENDERING_IN_SANDWICH = "IsRenderingInSandwich";
    public static final double MODEL_SCALE = 0.75;

    public static void loadRenderingHandlers() {
        SandwichableRenderingRegistry.registerRenderingHandler(KitchenItems.bread_slice, new ISandwichableRenderingHandler(){

            @Override
            public ModelBase getModel(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                if (indexInList == itemStacks.length - 1) {
                    return new ModelBreadSliceTop();
                }
                return new ModelBreadSliceBottom();
            }

            @Override
            public double getModelHeight(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                return 0.125;
            }
        });
        SandwichableRenderingRegistry.registerRenderingHandler(KitchenItems.bacon, new ISandwichableRenderingHandler(){

            @Override
            public ModelBase getModel(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                return new ModelBaconCooked();
            }

            @Override
            public double getModelHeight(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                return 0.125;
            }
        });
        SandwichableRenderingRegistry.registerRenderingHandler(KitchenItems.raw_bacon, new ISandwichableRenderingHandler(){

            @Override
            public ModelBase getModel(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                return new ModelBaconRaw();
            }

            @Override
            public double getModelHeight(ItemStack[] itemStacks, int indexInList, NBTTagCompound compound) {
                return 0.0625;
            }
        });
        SandwichableRenderingRegistry.registerRenderingHandler(KitchenItems.butter, new ISandwichableRenderingHandler(){

            @Override
            public ModelBase getModel(ItemStack[] itemStacks, int indexInList, NBTTagCompound specialTagInfo) {
                if (specialTagInfo != null && specialTagInfo.func_74764_b("ClickAmount")) {
                    int clickAmount = specialTagInfo.func_74762_e("ClickAmount");
                    switch (clickAmount) {
                        case 0: {
                            return new ModelButter0();
                        }
                        case 1: {
                            return new ModelButter1();
                        }
                        case 2: {
                            return new ModelButter2();
                        }
                    }
                    return new ModelButter0();
                }
                return new ModelButter0();
            }

            @Override
            public double getModelHeight(ItemStack[] itemStacks, int indexInList, NBTTagCompound specialTagInfo) {
                return 0.05;
            }
        });
    }

    public static double renderSandwich(Sandwich sandwich) {
        ItemStack[] stacks = sandwich.items;
        double yOffset = 0.0;
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack stack = stacks[i];
            ClientUtils.push();
            ClientUtils.translate(0.0, yOffset, 0.0);
            yOffset += SandwichRender.renderItem(stack, i, sandwich);
            ClientUtils.pop();
        }
        return yOffset;
    }

    private static double renderItem(ItemStack stack, int index, Sandwich sandwich) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a(IS_RENDERING_IN_SANDWICH, true);
        }
        NBTTagCompound compound = index == sandwich.items.length - 1 ? sandwich.info : null;
        ISandwichableRenderingHandler renderingHandler = SandwichableRenderingRegistry.getRenderingHandlerFor(stack);
        ModelBase model = renderingHandler.getModel(sandwich.items, index, compound);
        double height = renderingHandler.getModelHeight(sandwich.items, index, compound);
        if (model != null) {
            ClientUtils.scale(0.75f);
            ClientUtils.translate(0.0f, 1.5f, 0.0f);
            ClientUtils.rotate(180.0f, 0.0f, 0.0f, 1.0f);
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            height *= 0.75;
        } else {
            ClientUtils.translate(0.0f, 0.015625f, 0.0f);
            ClientUtils.rotate(90.0f, 1.0f, 0.0f, 0.0f);
            ClientUtils.renderItemStack(stack);
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(IS_RENDERING_IN_SANDWICH);
        }
        return height;
    }

    public static class Sandwich {
        NBTTagCompound info = null;
        ItemStack[] items;

        public Sandwich(ItemStack itemStack) {
            if (!itemStack.func_77942_o()) {
                this.items = new ItemStack[0];
            } else {
                NBTTagList list = itemStack.func_77978_p().func_150295_c("SandwichLayers", 10);
                if (list.func_74745_c() > 0) {
                    this.items = new ItemStack[list.func_74745_c()];
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        this.items[i] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                    }
                } else {
                    this.items = new ItemStack[0];
                }
            }
        }

        public Sandwich(List<ItemStack> items, NBTTagCompound compound) {
            this.items = items.toArray(new ItemStack[items.size()]);
            this.info = compound;
        }
    }
}

