/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.model;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.ClientUtils;
import dk.mrspring.kitchen.model.IRenderParameter;
import dk.mrspring.kitchen.model.ModelPart;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class ModelBase<T extends IRenderParameter>
extends net.minecraft.client.model.ModelBase {
    public ResourceLocation texture;
    List<ModelPart> parts = Lists.newLinkedList();
    ModelPart basePart;

    public ModelBase(ResourceLocation texture, int textureWidth, int textureHeight, ModelPart ... parts) {
        this.texture = texture;
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
        Collections.addAll(this.parts, parts);
        this.basePart = new ModelPart(this);
    }

    public ModelBase(String texture, int textureWidth, int textureHeight, ModelPart ... parts) {
        this(ClientUtils.modelTexture(texture), textureWidth, textureHeight, parts);
    }

    public T makeDefaultParameter() {
        return null;
    }

    public RenderContext makeContext() {
        return this.makeContext(0.0f);
    }

    public RenderContext makeContext(float partial) {
        return new RenderContext(this, partial, this.makeDefaultParameter());
    }

    public void preRender(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, RenderContext context) {
    }

    public void simpleRender(float partial) {
        this.render((Entity)null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, partial);
    }

    public void simpleRender(float partial, T parameters) {
        this.render(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, partial, parameters);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, float partial) {
        this.render(entity, f, f1, f2, f3, f4, f5, this.makeContext(partial));
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.render(entity, f, f1, f2, f3, f4, f5, this.makeContext());
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, float partial, T parameters) {
        RenderContext context = this.makeContext(partial);
        context.parameters = parameters;
        this.render(entity, f, f1, f2, f3, f4, f5, context);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, T parameters) {
        this.render(entity, f, f1, f2, f3, f4, f5, 0.0f, parameters);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, RenderContext context) {
        this.preRender(entity, f, f1, f2, f3, f4, f5, context);
        ClientUtils.push();
        ClientUtils.bind(this.getTexture(context));
        ClientUtils.enableTextures();
        for (ModelRenderer modelRenderer : this.parts) {
            modelRenderer.func_78785_a(f5);
        }
        this.basePart.func_78785_a(f5);
        this.renderExtras(entity, f, f1, f2, f3, f4, f5, context);
        ClientUtils.pop();
    }

    public void renderExtras(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, RenderContext context) {
    }

    public ResourceLocation getTexture(RenderContext context) {
        return this.texture;
    }

    public ModelBase renderBox(int u, int v, float xOffset, float yOffset, float zOffset, int width, int height, int depth, float pivotX, float pivotY, float pivotZ, float rotationX, float rotationY, float rotationZ, float f5) {
        ModelPart box = new ModelPart(this).setPivot(pivotX, pivotY, pivotZ).setRotation(rotationX, rotationY, rotationZ).addBox(u, v, xOffset, yOffset, zOffset, width, height, depth);
        box.func_78785_a(f5);
        return this;
    }

    public ModelBase renderBox(int u, int v, float x, float y, float z, int width, int height, int depth, float f5) {
        return this.renderBox(u, v, 0.0f, 0.0f, 0.0f, width, height, depth, x, y, z, 0.0f, 0.0f, 0.0f, f5);
    }

    public ModelBase addPart(ModelPart part) {
        this.parts.add(part);
        return this;
    }

    public ModelPart addPart() {
        return this.addPart(0.0f, 0.0f, 0.0f);
    }

    public ModelPart addPart(float xPivot, float yPivot, float zPivot) {
        return this.addPart(null, xPivot, yPivot, zPivot);
    }

    public ModelPart addPart(String name, float xPivot, float yPivot, float zPivot) {
        ModelPart part = new ModelPart(this, name).setPivot(xPivot, yPivot, zPivot).setTextureSize(this.field_78090_t, this.field_78089_u);
        this.parts.add(part);
        return part;
    }

    public ModelBase addBox(int u, int v, float x, float y, float z, int width, int height, int depth) {
        this.basePart.addBox(u, v, x, y, z, width, height, depth);
        return this;
    }

    public void setRotation(float x, float y, float z, int ... indexes) {
        for (int i : indexes) {
            this.setRotation(i, x, y, z);
        }
    }

    public void setRotation(int index, float x, float y, float z) {
        this.setRotation(this.parts.get(index), x, y, z);
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public ModelBase hideModels(int ... indexes) {
        for (int i : indexes) {
            this.hideModel(i);
        }
        return this;
    }

    public ModelBase hideModel(int index) {
        return this.hideModel(this.parts.get(index));
    }

    public ModelBase hideModels(ModelPart ... parts) {
        for (ModelPart part : parts) {
            this.hideModel(part);
        }
        return this;
    }

    public ModelBase hideModel(ModelPart part) {
        part.field_78807_k = true;
        return this;
    }

    public ModelBase showModels(int ... indexes) {
        for (int i : indexes) {
            this.showModel(i);
        }
        return this;
    }

    public ModelBase showModel(int index) {
        this.parts.get((int)index).field_78807_k = false;
        return this;
    }

    public ModelBase showModels(ModelPart ... parts) {
        for (ModelPart part : parts) {
            this.showModel(part);
        }
        return this;
    }

    public ModelBase showModel(ModelPart part) {
        part.field_78807_k = false;
        return this;
    }

    public static class RenderContext {
        public final float xOffset;
        public final float yOffset;
        public final float zOffset;
        public final float xRotation;
        public final float yRotation;
        public final float zRotation;
        public final float xScale;
        public final float yScale;
        public final float zScale;
        public final float partial;
        public T parameters = null;
        final /* synthetic */ ModelBase this$0;

        public RenderContext(ModelBase this$0) {
            this(this$0, 0.0f);
        }

        public RenderContext(ModelBase this$0, float partial) {
            this(this$0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, partial, null);
        }

        public RenderContext(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation, float xScale, float yScale, float zScale, float partial, T parameters) {
            this.this$0 = this$0;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.zRotation = zRotation;
            this.xScale = xScale;
            this.yScale = yScale;
            this.zScale = zScale;
            this.partial = partial;
            this.parameters = parameters;
        }

        public RenderContext(T parameters) {
            this(this$0, 0.0f, (IRenderParameter)parameters);
        }

        public RenderContext(float partial, T parameters) {
            this(this$0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, partial, (IRenderParameter)parameters);
        }
    }
}

