/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.pan;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.item.ItemJamJar;
import dk.mrspring.kitchen.pan.IIngredientRenderingHandler;
import dk.mrspring.kitchen.tileentity.TileEntityPan;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Ingredient {
    public static final Ingredient EMPTY = new Ingredient("empty", "empty", (ItemStack)null);
    public static Map<String, Ingredient> ingredients = new HashMap<String, Ingredient>();
    @SideOnly(value=Side.CLIENT)
    IIngredientRenderingHandler renderingHandler;
    String name;
    String unlocalizedName;
    ItemStack result;

    public Ingredient(String name, String unlocalizedName, String jamResult) {
        this(name, unlocalizedName, ItemJamJar.getJamJarItemStack(jamResult, 6));
    }

    public Ingredient(String name, String unlocalizedName, Item item) {
        this(name, unlocalizedName, new ItemStack(item));
    }

    public Ingredient(String name, String unlocalizedName, ItemStack result) {
        this.name = name;
        this.unlocalizedName = unlocalizedName;
        this.result = result;
    }

    @SideOnly(value=Side.CLIENT)
    public Ingredient setRenderingHandler(IIngredientRenderingHandler handler) {
        this.renderingHandler = handler;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIngredientRenderingHandler getRenderingHandler() {
        return this.renderingHandler;
    }

    public boolean canRemove(TileEntityPan pan, ItemStack clicked) {
        if (!pan.isFinished()) {
            return false;
        }
        if (ItemJamJar.isJar(this.result)) {
            return ItemJamJar.isEmptyJar(clicked);
        }
        return clicked == null;
    }

    public ItemStack[] onRemoved(TileEntityPan pan, ItemStack clicked) {
        if (clicked != null && clicked.field_77994_a > 0) {
            --clicked.field_77994_a;
        }
        return new ItemStack[]{this.result.func_77946_l()};
    }

    public String getName() {
        return this.name;
    }

    public static void registerIngredient(Ingredient ingredient) {
        if (ingredient != null && !ingredients.containsKey(ingredient.getName())) {
            ingredients.put(ingredient.getName(), ingredient);
        }
    }

    public static Ingredient getIngredient(String name) {
        if (name != null && ingredients.containsKey(name)) {
            return ingredients.get(name);
        }
        return EMPTY;
    }

    public static void bindRenderingHandler(String name, IIngredientRenderingHandler handler) {
        Ingredient ingredient = Ingredient.getIngredient(name);
        if (ingredient != EMPTY) {
            ingredient.setRenderingHandler(handler);
        }
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.unlocalizedName, (Object[])new Object[0]);
    }

    static {
        ingredients.put("empty", EMPTY);
    }
}

