/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.ModConfig;
import dk.mrspring.kitchen.ModLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class OvenRecipes {
    public static String[] defaultInput = new String[]{"kitchen:raw_roast_beef", "kitchen:chicken_fillet_raw", "kitchen:bacon_raw"};
    public static String[] defaultOutput = new String[]{"kitchen:roast_beef", "kitchen:chicken_fillet_cooked", "kitchen:bacon_cooked"};
    static Map<ItemStack, ItemStack> customOvenRecipes = new HashMap<ItemStack, ItemStack>();

    public static void load() {
        if (ModConfig.getOvenConfig().custom_oven_recipes_input.length == ModConfig.getOvenConfig().custom_oven_recipes_output.length) {
            ArrayList<ItemStack> input = OvenRecipes.getArrayFromStringList(ModConfig.getOvenConfig().custom_oven_recipes_input, "Custom Oven Recipes Input");
            ArrayList<ItemStack> output = OvenRecipes.getArrayFromStringList(ModConfig.getOvenConfig().custom_oven_recipes_output, "Custom Oven Recipes Output");
            if (input.size() == output.size()) {
                OvenRecipes.setCustomOvenRecipes(input, output);
            } else {
                ModLogger.print(0, "Unable to load Custom oven recipes! Loading defaults.");
                ModLogger.print(3, "Some of the Items it was trying to load has wrong names. Correct this issue to load custom recipes!");
                OvenRecipes.setCustomOvenRecipes(input, output);
            }
        } else {
            ModLogger.print(0, "Unable to load Custom oven recipes! Loading defaults.");
            ModLogger.print(3, "One of the list were bigger than the other! Input length: " + ModConfig.getOvenConfig().custom_oven_recipes_input.length + ", Output length: " + ModConfig.getOvenConfig().custom_oven_recipes_output.length);
            OvenRecipes.setCustomOvenRecipes(OvenRecipes.getArrayFromStringList(defaultInput, "Default Oven Input"), OvenRecipes.getArrayFromStringList(defaultOutput, "Default Oven Output"));
        }
    }

    public static void addFoodRecipes() {
        Map smeltingRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : smeltingRecipes.entrySet()) {
            if (!(((ItemStack)entry.getValue()).func_77973_b() instanceof ItemFood)) continue;
            ItemStack input = (ItemStack)entry.getKey();
            if (input.func_77960_j() > 1000) {
                input.func_77964_b(0);
            }
            customOvenRecipes.put(input, (ItemStack)entry.getValue());
        }
    }

    public static Map<ItemStack, ItemStack> getCustomOvenRecipes() {
        return customOvenRecipes;
    }

    private static void setCustomOvenRecipes(ArrayList<ItemStack> input, ArrayList<ItemStack> output) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack inputStack = input.get(i);
            ItemStack outputStack = output.get(i);
            customOvenRecipes.put(inputStack, outputStack);
        }
    }

    public static ItemStack getCookingResult(ItemStack input1) {
        for (Map.Entry<ItemStack, ItemStack> entry : customOvenRecipes.entrySet()) {
            ItemStack input2 = entry.getKey();
            if (!input1.func_77969_a(input2)) continue;
            return entry.getValue().func_77946_l();
        }
        ItemStack furnaceOutput = FurnaceRecipes.func_77602_a().func_151395_a(input1);
        if (furnaceOutput != null && furnaceOutput.func_77973_b() instanceof ItemFood) {
            furnaceOutput.func_77946_l();
        }
        return null;
    }

    public static ArrayList<ItemStack> getArrayFromStringList(String[] list, String type) {
        ArrayList<ItemStack> itemStackArrayList = new ArrayList<ItemStack>();
        for (String aList : list) {
            String itemName;
            String modId = "minecraft";
            if (aList.contains(":")) {
                modId = aList.split(":")[0];
                itemName = aList.split(":")[1];
            } else {
                itemName = aList;
            }
            ItemStack stack = GameRegistry.findItemStack((String)modId, (String)itemName, (int)1);
            if (stack != null) {
                ModLogger.print(3, "Adding " + stack.func_82833_r() + " to '" + type + "'.");
                itemStackArrayList.add(stack);
                continue;
            }
            ModLogger.print(3, "Unable to add ItemStack to '" + type + "', it returned null. ModID: " + modId + ", name: " + itemName + ".");
        }
        return itemStackArrayList;
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        if (input != null && output != null) {
            customOvenRecipes.put(input, output);
        }
    }
}

